/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class SegmentGenerationMetrics {
    private static final long NO_EMIT_SEGMENT_HANDOFF_TIME = -1L;
    private static final long NO_EMIT_MESSAGE_GAP = -1L;
    private final AtomicLong dedupCount = new AtomicLong(0L);
    private final AtomicLong rowOutputCount = new AtomicLong(0L);
    private final AtomicLong numPersists = new AtomicLong(0L);
    private final AtomicLong persistTimeMillis = new AtomicLong(0L);
    private final AtomicLong persistBackPressureMillis = new AtomicLong(0L);
    private final AtomicLong failedPersists = new AtomicLong(0L);
    private final AtomicLong failedHandoffs = new AtomicLong(0L);
    private final AtomicLong mergedRows = new AtomicLong(0L);
    private final AtomicLong pushedRows = new AtomicLong(0L);
    private final AtomicLong mergeTimeMillis = new AtomicLong(0L);
    private final AtomicLong mergeCpuTime = new AtomicLong(0L);
    private final AtomicLong persistCpuTime = new AtomicLong(0L);
    private final AtomicLong handOffCount = new AtomicLong(0L);
    private final AtomicLong sinkCount = new AtomicLong(0L);
    private final AtomicLong messageMaxTimestamp = new AtomicLong(0L);
    private final AtomicLong messageGap = new AtomicLong(0L);
    private final AtomicBoolean processingDone = new AtomicBoolean(false);
    private final AtomicLong maxSegmentHandoffTime = new AtomicLong(-1L);

    public void incrementRowOutputCount(long numRows) {
        this.rowOutputCount.addAndGet(numRows);
    }

    public void incrementNumPersists() {
        this.numPersists.incrementAndGet();
    }

    public void incrementPersistTimeMillis(long millis) {
        this.persistTimeMillis.addAndGet(millis);
    }

    public void incrementPersistBackPressureMillis(long millis) {
        this.persistBackPressureMillis.addAndGet(millis);
    }

    public void incrementFailedPersists() {
        this.failedPersists.incrementAndGet();
    }

    public void incrementFailedHandoffs() {
        this.failedHandoffs.incrementAndGet();
    }

    public void incrementMergedRows(long rows) {
        this.mergedRows.addAndGet(rows);
    }

    public void incrementPushedRows(long rows) {
        this.pushedRows.addAndGet(rows);
    }

    public void incrementHandOffCount() {
        this.handOffCount.incrementAndGet();
    }

    public void setSinkCount(long sinkCount) {
        this.sinkCount.set(sinkCount);
    }

    public void reportMessageMaxTimestamp(long messageMaxTimestamp) {
        this.messageMaxTimestamp.set(Math.max(messageMaxTimestamp, this.messageMaxTimestamp.get()));
    }

    public void reportMaxSegmentHandoffTime(long maxSegmentHandoffTime) {
        this.maxSegmentHandoffTime.set(Math.max(maxSegmentHandoffTime, this.maxSegmentHandoffTime.get()));
    }

    public void markProcessingDone() {
        this.processingDone.set(true);
    }

    @VisibleForTesting
    public boolean isProcessingDone() {
        return this.processingDone.get();
    }

    public long dedup() {
        return this.dedupCount.get();
    }

    public long rowOutput() {
        return this.rowOutputCount.get();
    }

    public long numPersists() {
        return this.numPersists.get();
    }

    public long persistTimeMillis() {
        return this.persistTimeMillis.get();
    }

    public long persistBackPressureMillis() {
        return this.persistBackPressureMillis.get();
    }

    public long failedPersists() {
        return this.failedPersists.get();
    }

    public long failedHandoffs() {
        return this.failedHandoffs.get();
    }

    public long mergedRows() {
        return this.mergedRows.get();
    }

    public long pushedRows() {
        return this.pushedRows.get();
    }

    public long mergeTimeMillis() {
        return this.mergeTimeMillis.get();
    }

    public long mergeCpuTime() {
        return this.mergeCpuTime.get();
    }

    public long persistCpuTime() {
        return this.persistCpuTime.get();
    }

    public long handOffCount() {
        return this.handOffCount.get();
    }

    public long sinkCount() {
        return this.sinkCount.get();
    }

    public long messageGap() {
        return this.messageGap.get();
    }

    public long maxSegmentHandoffTime() {
        return this.maxSegmentHandoffTime.get();
    }

    public SegmentGenerationMetrics snapshot() {
        SegmentGenerationMetrics retVal = new SegmentGenerationMetrics();
        retVal.dedupCount.set(this.dedupCount.get());
        retVal.rowOutputCount.set(this.rowOutputCount.get());
        retVal.numPersists.set(this.numPersists.get());
        retVal.persistTimeMillis.set(this.persistTimeMillis.get());
        retVal.persistBackPressureMillis.set(this.persistBackPressureMillis.get());
        retVal.failedPersists.set(this.failedPersists.get());
        retVal.failedHandoffs.set(this.failedHandoffs.get());
        retVal.mergeTimeMillis.set(this.mergeTimeMillis.get());
        retVal.mergeCpuTime.set(this.mergeCpuTime.get());
        retVal.persistCpuTime.set(this.persistCpuTime.get());
        retVal.handOffCount.set(this.handOffCount.get());
        retVal.sinkCount.set(this.sinkCount.get());
        retVal.messageMaxTimestamp.set(this.messageMaxTimestamp.get());
        retVal.maxSegmentHandoffTime.set(this.maxSegmentHandoffTime.get());
        retVal.mergedRows.set(this.mergedRows.get());
        retVal.pushedRows.set(this.pushedRows.get());
        long messageGapSnapshot = 0L;
        long maxTimestamp = retVal.messageMaxTimestamp.get();
        if (this.processingDone.get()) {
            messageGapSnapshot = -1L;
        } else if (maxTimestamp > 0L) {
            messageGapSnapshot = System.currentTimeMillis() - maxTimestamp;
        }
        retVal.messageGap.set(messageGapSnapshot);
        this.reset();
        return retVal;
    }

    private void reset() {
        this.maxSegmentHandoffTime.set(-1L);
    }
}

