/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.client.ServerViewUtil;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.query.Query;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryResource;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.ResponseContextConfig;
import org.apache.druid.server.http.security.StateResourceFilter;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthorizerMapper;
import org.joda.time.Interval;

@Path(value="/druid/v2/")
public class BrokerQueryResource
extends QueryResource {
    private final TimelineServerView brokerServerView;

    @Inject
    public BrokerQueryResource(QueryLifecycleFactory queryLifecycleFactory, @Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, QueryScheduler queryScheduler, AuthConfig authConfig, AuthorizerMapper authorizerMapper, ResponseContextConfig responseContextConfig, @Self DruidNode selfNode, TimelineServerView brokerServerView) {
        super(queryLifecycleFactory, jsonMapper, smileMapper, queryScheduler, authConfig, authorizerMapper, responseContextConfig, selfNode);
        this.brokerServerView = brokerServerView;
    }

    @POST
    @Path(value="/candidates")
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile", "application/smile"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getQueryTargets(InputStream in, @QueryParam(value="pretty") String pretty, @QueryParam(value="numCandidates") @DefaultValue(value="-1") int numCandidates, @Context HttpServletRequest req) throws IOException {
        QueryResource.ResourceIOReaderWriter ioReaderWriter = this.createResourceIOReaderWriter(req, pretty != null);
        try {
            Query query = (Query)ioReaderWriter.getRequestMapper().readValue(in, Query.class);
            return ioReaderWriter.getResponseWriter().ok(ServerViewUtil.getTargetLocations(this.brokerServerView, query.getDataSource(), (List<Interval>)query.getIntervals(), numCandidates));
        }
        catch (Exception e) {
            return ioReaderWriter.getResponseWriter().gotError(e);
        }
    }
}

