/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.common.config.Configs;
import org.joda.time.Duration;

public class HttpLoadQueuePeonConfig {
    private static final Duration DEFAULT_LOAD_TIMEOUT = Duration.standardMinutes((long)15L);
    @JsonProperty
    private final Duration hostTimeout;
    @JsonProperty
    private final Duration repeatDelay;
    @JsonProperty
    private final int batchSize;

    @JsonCreator
    public HttpLoadQueuePeonConfig(@JsonProperty(value="hostTimeout") Duration hostTimeout, @JsonProperty(value="repeatDelay") Duration repeatDelay, @JsonProperty(value="batchSize") Integer batchSize) {
        this.hostTimeout = (Duration)Configs.valueOrDefault((Object)hostTimeout, (Object)Duration.standardMinutes((long)5L));
        this.repeatDelay = (Duration)Configs.valueOrDefault((Object)repeatDelay, (Object)Duration.standardMinutes((long)1L));
        this.batchSize = Configs.valueOrDefault((Integer)batchSize, (int)1);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public Duration getHostTimeout() {
        return this.hostTimeout;
    }

    public Duration getRepeatDelay() {
        return this.repeatDelay;
    }

    public Duration getLoadTimeout() {
        return DEFAULT_LOAD_TIMEOUT;
    }
}

