/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.loading;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.loading.SegmentAction;
import org.apache.druid.server.coordinator.loading.SegmentReplicaCount;
import org.apache.druid.server.coordinator.loading.SegmentReplicationStatus;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;

public class SegmentReplicaCountMap {
    private final Map<SegmentId, Map<String, SegmentReplicaCount>> replicaCounts = new HashMap<SegmentId, Map<String, SegmentReplicaCount>>();

    static SegmentReplicaCountMap create(DruidCluster cluster) {
        SegmentReplicaCountMap replicaCountMap = new SegmentReplicaCountMap();
        replicaCountMap.initReplicaCounts(cluster);
        return replicaCountMap;
    }

    private void initReplicaCounts(DruidCluster cluster) {
        cluster.getHistoricals().forEach((tier, historicals) -> historicals.forEach(serverHolder -> {
            for (DataSegment segment2 : serverHolder.getServedSegments()) {
                this.computeIfAbsent(segment2.getId(), (String)tier).incrementLoaded();
            }
            serverHolder.getQueuedSegments().forEach((segment, state) -> this.computeIfAbsent(segment.getId(), (String)tier).incrementQueued((SegmentAction)((Object)((Object)((Object)state)))));
        }));
        cluster.getBrokers().forEach(broker -> {
            ImmutableDruidServer server = broker.getServer();
            for (DataSegment segment : server.iterateAllSegments()) {
                this.computeIfAbsent(segment.getId(), server.getTier()).incrementLoadedOnNonHistoricalServer();
            }
        });
        cluster.getRealtimes().forEach(realtime -> {
            ImmutableDruidServer server = realtime.getServer();
            for (DataSegment segment : server.iterateAllSegments()) {
                this.computeIfAbsent(segment.getId(), server.getTier()).incrementLoadedOnNonHistoricalServer();
            }
        });
    }

    SegmentReplicaCount get(SegmentId segmentId, String tier) {
        SegmentReplicaCount count = (SegmentReplicaCount)this.replicaCounts.getOrDefault(segmentId, Collections.emptyMap()).get(tier);
        return count == null ? new SegmentReplicaCount() : count;
    }

    SegmentReplicaCount getTotal(SegmentId segmentId) {
        SegmentReplicaCount total = new SegmentReplicaCount();
        this.replicaCounts.getOrDefault(segmentId, Collections.emptyMap()).values().forEach(total::accumulate);
        return total;
    }

    public SegmentReplicaCount computeIfAbsent(SegmentId segmentId, String tier) {
        return this.replicaCounts.computeIfAbsent(segmentId, (? super K s) -> new HashMap()).computeIfAbsent(tier, (? super K t) -> new SegmentReplicaCount());
    }

    public SegmentReplicationStatus toReplicationStatus() {
        return new SegmentReplicationStatus(this.replicaCounts);
    }
}

