/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.emitter;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.SwitchingEmitter;
import org.apache.druid.server.emitter.SwitchingEmitterConfig;

public class SwitchingEmitterModule
implements Module {
    public static final String EMITTER_TYPE = "switching";
    private static Logger log = new Logger(SwitchingEmitterModule.class);

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.emitter.switching", SwitchingEmitterConfig.class);
    }

    @Provides
    @ManageLifecycle
    @Named(value="switching")
    public Emitter makeEmitter(SwitchingEmitterConfig config, Injector injector) {
        log.info("Createing Switching emitter with %s, and default emitter %s", new Object[]{config.getEmitters(), config.getDefaultEmitter()});
        Map<String, List> switchingEmitters = config.getEmitters().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(emitterName -> (Emitter)injector.getInstance(Key.get(Emitter.class, (Annotation)Names.named((String)emitterName)))).collect(Collectors.toList())));
        ImmutableList.Builder defaultEmittersBuilder = new ImmutableList.Builder();
        for (String emitterName : config.getDefaultEmitter()) {
            defaultEmittersBuilder.add((Object)((Emitter)injector.getInstance(Key.get(Emitter.class, (Annotation)Names.named((String)emitterName)))));
        }
        return new SwitchingEmitter(switchingEmitters, (Emitter[])defaultEmittersBuilder.build().toArray((Object[])new Emitter[0]));
    }
}

