/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.KeyUtil;

public final class DefaultHashAlgorithm
extends Enum<DefaultHashAlgorithm>
implements HashAlgorithm {
    public static final /* enum */ DefaultHashAlgorithm NATIVE_HASH = new DefaultHashAlgorithm();
    public static final /* enum */ DefaultHashAlgorithm CRC_HASH = new DefaultHashAlgorithm();
    public static final /* enum */ DefaultHashAlgorithm FNV1_64_HASH = new DefaultHashAlgorithm();
    public static final /* enum */ DefaultHashAlgorithm FNV1A_64_HASH = new DefaultHashAlgorithm();
    public static final /* enum */ DefaultHashAlgorithm FNV1_32_HASH = new DefaultHashAlgorithm();
    public static final /* enum */ DefaultHashAlgorithm FNV1A_32_HASH = new DefaultHashAlgorithm();
    public static final /* enum */ DefaultHashAlgorithm KETAMA_HASH = new DefaultHashAlgorithm();
    private static final long FNV_64_INIT = -3750763034362895579L;
    private static final long FNV_64_PRIME = 1099511628211L;
    private static final long FNV_32_INIT = 2166136261L;
    private static final long FNV_32_PRIME = 16777619L;
    private static MessageDigest msgHashDigest;
    private static final /* synthetic */ DefaultHashAlgorithm[] $VALUES;

    public static DefaultHashAlgorithm[] values() {
        return (DefaultHashAlgorithm[])$VALUES.clone();
    }

    public static DefaultHashAlgorithm valueOf(String name) {
        return Enum.valueOf(DefaultHashAlgorithm.class, name);
    }

    @Override
    public long hash(String k) {
        long rv = 0L;
        int len = k.length();
        switch (this) {
            case NATIVE_HASH: {
                rv = k.hashCode();
                break;
            }
            case CRC_HASH: {
                CRC32 crc32 = new CRC32();
                crc32.update(KeyUtil.getKeyBytes(k));
                rv = crc32.getValue() >> 16 & 0x7FFFL;
                break;
            }
            case FNV1_64_HASH: {
                rv = -3750763034362895579L;
                for (int i = 0; i < len; ++i) {
                    rv *= 1099511628211L;
                    rv ^= (long)k.charAt(i);
                }
                break;
            }
            case FNV1A_64_HASH: {
                rv = -3750763034362895579L;
                for (int i = 0; i < len; ++i) {
                    rv ^= (long)k.charAt(i);
                    rv *= 1099511628211L;
                }
                break;
            }
            case FNV1_32_HASH: {
                rv = 2166136261L;
                for (int i = 0; i < len; ++i) {
                    rv *= 16777619L;
                    rv ^= (long)k.charAt(i);
                }
                break;
            }
            case FNV1A_32_HASH: {
                rv = 2166136261L;
                for (int i = 0; i < len; ++i) {
                    rv ^= (long)k.charAt(i);
                    rv *= 16777619L;
                }
                break;
            }
            case KETAMA_HASH: {
                byte[] bKey = DefaultHashAlgorithm.computeHashDigest(k);
                rv = (long)(bKey[3] & 0xFF) << 24 | (long)(bKey[2] & 0xFF) << 16 | (long)(bKey[1] & 0xFF) << 8 | (long)(bKey[0] & 0xFF);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return rv & 0xFFFFFFFFL;
    }

    public static byte[] computeHashDigest(String k) {
        MessageDigest msgDigest;
        try {
            msgDigest = (MessageDigest)msgHashDigest.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("clone of SHA-384 not supported", e);
        }
        msgDigest.update(KeyUtil.getKeyBytes(k));
        return msgDigest.digest();
    }

    static {
        $VALUES = new DefaultHashAlgorithm[]{NATIVE_HASH, CRC_HASH, FNV1_64_HASH, FNV1A_64_HASH, FNV1_32_HASH, FNV1A_32_HASH, KETAMA_HASH};
        msgHashDigest = null;
        try {
            msgHashDigest = MessageDigest.getInstance("SHA-384");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-384 not supported", e);
        }
    }
}

