/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.leases.impl;

import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.leases.impl.HashKeyRangeForLease;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.impl.LeaseSerializer;
import com.amazonaws.services.kinesis.leases.impl.UpdateField;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseSerializer;
import com.amazonaws.services.kinesis.leases.util.DynamoUtils;
import com.amazonaws.util.CollectionUtils;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class KinesisClientLeaseSerializer
implements ILeaseSerializer<KinesisClientLease> {
    private static final String OWNER_SWITCHES_KEY = "ownerSwitchesSinceCheckpoint";
    private static final String CHECKPOINT_SEQUENCE_NUMBER_KEY = "checkpoint";
    private static final String CHECKPOINT_SUBSEQUENCE_NUMBER_KEY = "checkpointSubSequenceNumber";
    private static final String PENDING_CHECKPOINT_SEQUENCE_KEY = "pendingCheckpoint";
    private static final String PENDING_CHECKPOINT_SUBSEQUENCE_KEY = "pendingCheckpointSubSequenceNumber";
    public final String PARENT_SHARD_ID_KEY = "parentShardId";
    public final String CHILD_SHARD_IDS_KEY = "childShardIds";
    private static final String STARTING_HASH_KEY = "startingHashKey";
    private static final String ENDING_HASH_KEY = "endingHashKey";
    private final LeaseSerializer baseSerializer = new LeaseSerializer(KinesisClientLease.class);

    @Override
    public Map<String, AttributeValue> toDynamoRecord(KinesisClientLease lease) {
        Map<String, AttributeValue> result = this.baseSerializer.toDynamoRecord(lease);
        result.put(OWNER_SWITCHES_KEY, DynamoUtils.createAttributeValue(lease.getOwnerSwitchesSinceCheckpoint()));
        result.put(CHECKPOINT_SEQUENCE_NUMBER_KEY, DynamoUtils.createAttributeValue(lease.getCheckpoint().getSequenceNumber()));
        result.put(CHECKPOINT_SUBSEQUENCE_NUMBER_KEY, DynamoUtils.createAttributeValue(lease.getCheckpoint().getSubSequenceNumber()));
        if (!CollectionUtils.isNullOrEmpty(lease.getParentShardIds())) {
            result.put("parentShardId", DynamoUtils.createAttributeValue(lease.getParentShardIds()));
        }
        if (!CollectionUtils.isNullOrEmpty(lease.getChildShardIds())) {
            result.put("childShardIds", DynamoUtils.createAttributeValue(lease.getChildShardIds()));
        }
        if (lease.getPendingCheckpoint() != null && !lease.getPendingCheckpoint().getSequenceNumber().isEmpty()) {
            result.put(PENDING_CHECKPOINT_SEQUENCE_KEY, DynamoUtils.createAttributeValue(lease.getPendingCheckpoint().getSequenceNumber()));
            result.put(PENDING_CHECKPOINT_SUBSEQUENCE_KEY, DynamoUtils.createAttributeValue(lease.getPendingCheckpoint().getSubSequenceNumber()));
        }
        if (lease.getHashKeyRange() != null) {
            result.put(STARTING_HASH_KEY, DynamoUtils.createAttributeValue(lease.getHashKeyRange().serializedStartingHashKey()));
            result.put(ENDING_HASH_KEY, DynamoUtils.createAttributeValue(lease.getHashKeyRange().serializedEndingHashKey()));
        }
        return result;
    }

    @Override
    public KinesisClientLease fromDynamoRecord(Map<String, AttributeValue> dynamoRecord) {
        String endingHashKey;
        String startingHashKey;
        KinesisClientLease result = (KinesisClientLease)this.baseSerializer.fromDynamoRecord(dynamoRecord);
        result.setOwnerSwitchesSinceCheckpoint(DynamoUtils.safeGetLong(dynamoRecord, OWNER_SWITCHES_KEY));
        result.setCheckpoint(new ExtendedSequenceNumber(DynamoUtils.safeGetString(dynamoRecord, CHECKPOINT_SEQUENCE_NUMBER_KEY), DynamoUtils.safeGetLong(dynamoRecord, CHECKPOINT_SUBSEQUENCE_NUMBER_KEY)));
        result.setParentShardIds(DynamoUtils.safeGetSS(dynamoRecord, "parentShardId"));
        result.setChildShardIds(DynamoUtils.safeGetSS(dynamoRecord, "childShardIds"));
        if (!Strings.isNullOrEmpty((String)DynamoUtils.safeGetString(dynamoRecord, PENDING_CHECKPOINT_SEQUENCE_KEY))) {
            result.setPendingCheckpoint(new ExtendedSequenceNumber(DynamoUtils.safeGetString(dynamoRecord, PENDING_CHECKPOINT_SEQUENCE_KEY), DynamoUtils.safeGetLong(dynamoRecord, PENDING_CHECKPOINT_SUBSEQUENCE_KEY)));
        }
        if (!Strings.isNullOrEmpty((String)(startingHashKey = DynamoUtils.safeGetString(dynamoRecord, STARTING_HASH_KEY))) && !Strings.isNullOrEmpty((String)(endingHashKey = DynamoUtils.safeGetString(dynamoRecord, ENDING_HASH_KEY)))) {
            result.setHashKeyRange(HashKeyRangeForLease.deserialize(startingHashKey, endingHashKey));
        }
        return result;
    }

    @Override
    public Map<String, AttributeValue> getDynamoHashKey(KinesisClientLease lease) {
        return this.baseSerializer.getDynamoHashKey(lease);
    }

    @Override
    public Map<String, AttributeValue> getDynamoHashKey(String shardId) {
        return this.baseSerializer.getDynamoHashKey(shardId);
    }

    @Override
    public Map<String, ExpectedAttributeValue> getDynamoLeaseCounterExpectation(KinesisClientLease lease) {
        return this.baseSerializer.getDynamoLeaseCounterExpectation(lease);
    }

    @Override
    public Map<String, ExpectedAttributeValue> getDynamoLeaseOwnerExpectation(KinesisClientLease lease) {
        return this.baseSerializer.getDynamoLeaseOwnerExpectation(lease);
    }

    @Override
    public Map<String, ExpectedAttributeValue> getDynamoLeaseCheckpointExpectation(KinesisClientLease lease) {
        Map<String, ExpectedAttributeValue> result = this.baseSerializer.getDynamoLeaseCheckpointExpectation(lease);
        if (!lease.getCheckpoint().equals(ExtendedSequenceNumber.SHARD_END)) {
            ExpectedAttributeValue eav = new ExpectedAttributeValue(DynamoUtils.createAttributeValue(ExtendedSequenceNumber.SHARD_END.getSequenceNumber()));
            eav.setComparisonOperator(ComparisonOperator.NE);
            result.put(CHECKPOINT_SEQUENCE_NUMBER_KEY, eav);
        }
        return result;
    }

    @Override
    public Map<String, ExpectedAttributeValue> getDynamoNonexistantExpectation() {
        return this.baseSerializer.getDynamoNonexistantExpectation();
    }

    @Override
    public Map<String, ExpectedAttributeValue> getDynamoExistentExpectation(String leaseKey) {
        return this.baseSerializer.getDynamoExistentExpectation(leaseKey);
    }

    @Override
    public Map<String, AttributeValueUpdate> getDynamoLeaseCounterUpdate(KinesisClientLease lease) {
        return this.baseSerializer.getDynamoLeaseCounterUpdate(lease);
    }

    @Override
    public Map<String, AttributeValueUpdate> getDynamoTakeLeaseUpdate(KinesisClientLease lease, String newOwner) {
        Map<String, AttributeValueUpdate> result = this.baseSerializer.getDynamoTakeLeaseUpdate(lease, newOwner);
        String oldOwner = lease.getLeaseOwner();
        if (oldOwner != null && !oldOwner.equals(newOwner)) {
            result.put(OWNER_SWITCHES_KEY, new AttributeValueUpdate(DynamoUtils.createAttributeValue(1L), AttributeAction.ADD));
        }
        return result;
    }

    @Override
    public Map<String, AttributeValueUpdate> getDynamoEvictLeaseUpdate(KinesisClientLease lease) {
        return this.baseSerializer.getDynamoEvictLeaseUpdate(lease);
    }

    @Override
    public Map<String, AttributeValueUpdate> getDynamoUpdateLeaseUpdate(KinesisClientLease lease) {
        Map<String, AttributeValueUpdate> result = this.baseSerializer.getDynamoUpdateLeaseUpdate(lease);
        result.put(CHECKPOINT_SEQUENCE_NUMBER_KEY, new AttributeValueUpdate(DynamoUtils.createAttributeValue(lease.getCheckpoint().getSequenceNumber()), AttributeAction.PUT));
        result.put(CHECKPOINT_SUBSEQUENCE_NUMBER_KEY, new AttributeValueUpdate(DynamoUtils.createAttributeValue(lease.getCheckpoint().getSubSequenceNumber()), AttributeAction.PUT));
        result.put(OWNER_SWITCHES_KEY, new AttributeValueUpdate(DynamoUtils.createAttributeValue(lease.getOwnerSwitchesSinceCheckpoint()), AttributeAction.PUT));
        if (!CollectionUtils.isNullOrEmpty(lease.getChildShardIds())) {
            result.put("childShardIds", new AttributeValueUpdate(DynamoUtils.createAttributeValue(lease.getChildShardIds()), AttributeAction.PUT));
        }
        if (lease.getHashKeyRange() != null) {
            result.put(STARTING_HASH_KEY, new AttributeValueUpdate(DynamoUtils.createAttributeValue(lease.getHashKeyRange().serializedStartingHashKey()), AttributeAction.PUT));
            result.put(ENDING_HASH_KEY, new AttributeValueUpdate(DynamoUtils.createAttributeValue(lease.getHashKeyRange().serializedEndingHashKey()), AttributeAction.PUT));
        }
        if (lease.getPendingCheckpoint() != null && !lease.getPendingCheckpoint().getSequenceNumber().isEmpty()) {
            result.put(PENDING_CHECKPOINT_SEQUENCE_KEY, new AttributeValueUpdate(DynamoUtils.createAttributeValue(lease.getPendingCheckpoint().getSequenceNumber()), AttributeAction.PUT));
            result.put(PENDING_CHECKPOINT_SUBSEQUENCE_KEY, new AttributeValueUpdate(DynamoUtils.createAttributeValue(lease.getPendingCheckpoint().getSubSequenceNumber()), AttributeAction.PUT));
        } else {
            result.put(PENDING_CHECKPOINT_SEQUENCE_KEY, new AttributeValueUpdate().withAction(AttributeAction.DELETE));
            result.put(PENDING_CHECKPOINT_SUBSEQUENCE_KEY, new AttributeValueUpdate().withAction(AttributeAction.DELETE));
        }
        return result;
    }

    @Override
    public Map<String, AttributeValueUpdate> getDynamoUpdateLeaseUpdate(KinesisClientLease lease, UpdateField updateField) {
        HashMap<String, AttributeValueUpdate> result = new HashMap<String, AttributeValueUpdate>();
        switch (updateField) {
            case CHILD_SHARDS: {
                if (CollectionUtils.isNullOrEmpty(lease.getChildShardIds())) break;
                result.put("childShardIds", new AttributeValueUpdate(DynamoUtils.createAttributeValue(lease.getChildShardIds()), AttributeAction.PUT));
                break;
            }
            case HASH_KEY_RANGE: {
                if (lease.getHashKeyRange() == null) break;
                result.put(STARTING_HASH_KEY, new AttributeValueUpdate(DynamoUtils.createAttributeValue(lease.getHashKeyRange().serializedStartingHashKey()), AttributeAction.PUT));
                result.put(ENDING_HASH_KEY, new AttributeValueUpdate(DynamoUtils.createAttributeValue(lease.getHashKeyRange().serializedEndingHashKey()), AttributeAction.PUT));
            }
        }
        return result;
    }

    @Override
    public Collection<KeySchemaElement> getKeySchema() {
        return this.baseSerializer.getKeySchema();
    }

    @Override
    public Collection<AttributeDefinition> getAttributeDefinitions() {
        return this.baseSerializer.getAttributeDefinitions();
    }
}

