/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.metrics;

import java.util.EnumMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.yarn.metrics.EventTypeMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@Metrics(context="yarn")
public class GenericEventTypeMetrics<T extends Enum<T>>
implements EventTypeMetrics<T> {
    static final Logger LOG = LoggerFactory.getLogger(GenericEventTypeMetrics.class);
    private final EnumMap<T, MutableGaugeLong> eventCountMetrics;
    private final EnumMap<T, MutableGaugeLong> processingTimeMetrics;
    private final MetricsRegistry registry;
    private final MetricsSystem ms;
    private final MetricsInfo info;
    private final Class<T> enumClass;
    private boolean isInitialized = false;

    public GenericEventTypeMetrics(MetricsInfo info, MetricsSystem ms, T[] enums, Class<T> enumClass) {
        this.enumClass = enumClass;
        this.eventCountMetrics = new EnumMap(this.enumClass);
        this.processingTimeMetrics = new EnumMap(this.enumClass);
        this.ms = ms;
        this.info = info;
        this.registry = new MetricsRegistry(this.info);
        for (T type : enums) {
            String eventCountMetricsName = ((Enum)type).toString() + "_event_count";
            String processingTimeMetricsName = ((Enum)type).toString() + "_processing_time";
            this.eventCountMetrics.put(type, this.registry.newGauge(eventCountMetricsName, eventCountMetricsName, 0L));
            this.processingTimeMetrics.put(type, this.registry.newGauge(processingTimeMetricsName, processingTimeMetricsName, 0L));
        }
    }

    public synchronized GenericEventTypeMetrics registerMetrics() {
        if (!this.isInitialized && this.ms != null) {
            LOG.info("Registering GenericEventTypeMetrics");
            this.ms.register(this.info.name(), this.info.description(), this);
            this.isInitialized = true;
        }
        return this;
    }

    @Override
    public void increment(T type, long processingTimeUs) {
        if (this.eventCountMetrics.get(type) != null) {
            this.eventCountMetrics.get(type).incr();
            this.processingTimeMetrics.get(type).incr(processingTimeUs);
        }
    }

    @Override
    public long get(T type) {
        return this.eventCountMetrics.get(type).value();
    }

    public long getTotalProcessingTime(T type) {
        return this.processingTimeMetrics.get(type).value();
    }

    public EnumMap<T, MutableGaugeLong> getEventCountMetrics() {
        return this.eventCountMetrics;
    }

    public EnumMap<T, MutableGaugeLong> getProcessingTimeMetrics() {
        return this.processingTimeMetrics;
    }

    public MetricsRegistry getRegistry() {
        return this.registry;
    }

    public MetricsInfo getInfo() {
        return this.info;
    }

    @Override
    public void getMetrics(MetricsCollector collector, boolean all) {
        this.registry.snapshot(collector.addRecord(this.registry.info()), all);
    }

    public Class<T> getEnumClass() {
        return this.enumClass;
    }

    public static class EventTypeMetricsBuilder<T extends Enum<T>> {
        private MetricsSystem ms;
        private MetricsInfo info;
        private Class<T> enumClass;
        private T[] enums;

        public EventTypeMetricsBuilder setEnumClass(Class<T> enumClassValue) {
            this.enumClass = enumClassValue;
            return this;
        }

        public EventTypeMetricsBuilder setEnums(T[] enumsValue) {
            this.enums = (Enum[])enumsValue.clone();
            return this;
        }

        public EventTypeMetricsBuilder setInfo(MetricsInfo infoValue) {
            this.info = infoValue;
            return this;
        }

        public EventTypeMetricsBuilder setMs(MetricsSystem msValue) {
            this.ms = msValue;
            return this;
        }

        public GenericEventTypeMetrics build() {
            return new GenericEventTypeMetrics(this.info, this.ms, this.enums, this.enumClass);
        }
    }
}

