/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog;

import com.google.common.collect.ImmutableMap;
import javax.ws.rs.core.Response;
import org.apache.druid.java.util.common.StringUtils;

public class CatalogException
extends Exception {
    public static final String DUPLICATE_ERROR = "Already exists";
    public static final String FAILED_ERROR = "Failed";
    public static final String INVALID_ERROR = "Invalid";
    public static final String NOT_FOUND_ERROR = "Not found";
    public static final String BAD_STATE = "Invalid table spec";
    public static final String ERROR_KEY = "error";
    public static final String ERR_MSG_KEY = "errorMessage";
    private final String errorCode;
    private final Response.Status responseCode;

    public CatalogException(String errorCode, Response.Status responseCode, String message, Object ... args) {
        super(StringUtils.format((String)message, (Object[])args));
        this.errorCode = errorCode;
        this.responseCode = responseCode;
    }

    public static CatalogException badRequest(String msg, Object ... args) {
        return new CatalogException(INVALID_ERROR, Response.Status.BAD_REQUEST, msg, args);
    }

    public Response toResponse() {
        return Response.status((Response.Status)this.responseCode).entity((Object)ImmutableMap.of((Object)ERROR_KEY, (Object)this.errorCode, (Object)ERR_MSG_KEY, (Object)this.getMessage())).build();
    }

    public static class DuplicateKeyException
    extends CatalogException {
        public DuplicateKeyException(String msg, Object ... args) {
            super(CatalogException.DUPLICATE_ERROR, Response.Status.BAD_REQUEST, msg, args);
        }
    }

    public static class NotFoundException
    extends CatalogException {
        public NotFoundException(String msg, Object ... args) {
            super(CatalogException.NOT_FOUND_ERROR, Response.Status.NOT_FOUND, msg, args);
        }
    }
}

