/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import java.util.List;
import org.apache.druid.catalog.http.CatalogResource;
import org.apache.druid.catalog.model.SchemaRegistry;
import org.apache.druid.catalog.model.SchemaRegistryImpl;
import org.apache.druid.catalog.storage.CatalogStorage;
import org.apache.druid.catalog.storage.MetadataStorageManager;
import org.apache.druid.catalog.storage.sql.CatalogManager;
import org.apache.druid.catalog.storage.sql.SQLCatalogManager;
import org.apache.druid.catalog.sync.CatalogUpdateNotifier;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.LoadScope;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.metadata.input.InputSourceModule;

@LoadScope(roles={"coordinator"})
public class CatalogCoordinatorModule
implements DruidModule {
    public void configure(Binder binder) {
        binder.bind(CatalogManager.class).to(SQLCatalogManager.class).in(LazySingleton.class);
        binder.bind(CatalogStorage.class).in(LazySingleton.class);
        binder.bind(MetadataStorageManager.class).in(LazySingleton.class);
        binder.bind(SchemaRegistry.class).to(SchemaRegistryImpl.class).in(LazySingleton.class);
        binder.bind(CatalogUpdateNotifier.class).in(ManageLifecycle.class);
        LifecycleModule.register((Binder)binder, CatalogUpdateNotifier.class);
        Jerseys.addResource((Binder)binder, CatalogResource.class);
        binder.install((Module)new InputSourceModule());
    }

    public List<? extends com.fasterxml.jackson.databind.Module> getJacksonModules() {
        return new InputSourceModule().getJacksonModules();
    }
}

