/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.nodelabels.AbstractLabel;
import org.apache.hadoop.yarn.nodelabels.AttributeValue;

public class RMNodeAttribute
extends AbstractLabel {
    private NodeAttribute attribute;
    private Map<String, AttributeValue> nodes = new HashMap<String, AttributeValue>();

    public RMNodeAttribute(NodeAttribute attribute) {
        this(attribute.getAttributeKey().getAttributeName(), Resource.newInstance(0, 0), 0, attribute);
    }

    public RMNodeAttribute(String labelName, Resource res, int activeNMs, NodeAttribute attribute) {
        super(labelName, res, activeNMs);
        this.attribute = attribute;
    }

    public NodeAttribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(NodeAttribute attribute) {
        this.attribute = attribute;
    }

    public NodeAttributeType getAttributeType() {
        return this.attribute.getAttributeType();
    }

    public void addNode(String node, AttributeValue attributeValue) {
        this.nodes.put(node, attributeValue);
    }

    public void removeNode(String node) {
        this.nodes.remove(node);
    }

    public Map<String, AttributeValue> getAssociatedNodeIds() {
        return new HashMap<String, AttributeValue>(this.nodes);
    }

    public int hashCode() {
        return this.attribute.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RMNodeAttribute other = (RMNodeAttribute)obj;
        return !(this.attribute == null ? other.attribute != null : !this.attribute.equals(other.attribute));
    }
}

