/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.LockResult;
import org.apache.druid.indexing.overlord.TimeChunkLockRequest;
import org.joda.time.Interval;

public class TimeChunkLockAcquireAction
implements TaskAction<TaskLock> {
    private final TaskLockType type;
    private final Interval interval;
    private final long timeoutMs;

    @JsonCreator
    public TimeChunkLockAcquireAction(@JsonProperty(value="lockType") @Nullable TaskLockType type, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="timeoutMs") long timeoutMs) {
        this.type = type == null ? TaskLockType.EXCLUSIVE : type;
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
        this.timeoutMs = timeoutMs;
    }

    @JsonProperty(value="lockType")
    public TaskLockType getType() {
        return this.type;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public TypeReference<TaskLock> getReturnTypeReference() {
        return new TypeReference<TaskLock>(){};
    }

    @Override
    public TaskLock perform(Task task, TaskActionToolbox toolbox) {
        try {
            LockResult result = this.timeoutMs == 0L ? toolbox.getTaskLockbox().lock(task, new TimeChunkLockRequest(this.type, task, this.interval, null)) : toolbox.getTaskLockbox().lock(task, new TimeChunkLockRequest(this.type, task, this.interval, null), this.timeoutMs);
            return result.getTaskLock();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        return "TimeChunkLockAcquireAction{lockType=" + this.type + ", interval=" + this.interval + ", timeoutMs=" + this.timeoutMs + "}";
    }
}

