/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.stats;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.druid.java.util.metrics.MonitorUtils;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.incremental.RowIngestionMetersTotals;
import org.apache.druid.segment.realtime.SegmentGenerationMetrics;

public class TaskRealtimeMetricsMonitor
extends AbstractMonitor {
    private static final EmittingLogger log = new EmittingLogger(TaskRealtimeMetricsMonitor.class);
    private final SegmentGenerationMetrics segmentGenerationMetrics;
    private final RowIngestionMeters rowIngestionMeters;
    private final Map<String, String[]> dimensions;
    @Nullable
    private final Map<String, Object> metricTags;
    private SegmentGenerationMetrics previousSegmentGenerationMetrics;
    private RowIngestionMetersTotals previousRowIngestionMetersTotals;

    public TaskRealtimeMetricsMonitor(SegmentGenerationMetrics segmentGenerationMetrics, RowIngestionMeters rowIngestionMeters, Map<String, String[]> dimensions, @Nullable Map<String, Object> metricTags) {
        this.segmentGenerationMetrics = segmentGenerationMetrics;
        this.rowIngestionMeters = rowIngestionMeters;
        this.dimensions = ImmutableMap.copyOf(dimensions);
        this.metricTags = metricTags;
        this.previousSegmentGenerationMetrics = new SegmentGenerationMetrics();
        this.previousRowIngestionMetersTotals = new RowIngestionMetersTotals(0L, 0L, 0L, 0L, 0L);
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        long maxSegmentHandoffTime;
        SegmentGenerationMetrics metrics = this.segmentGenerationMetrics.snapshot();
        RowIngestionMetersTotals rowIngestionMetersTotals = this.rowIngestionMeters.getTotals();
        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
        MonitorUtils.addDimensionsToBuilder((ServiceMetricEvent.Builder)builder, this.dimensions);
        long thrownAway = rowIngestionMetersTotals.getThrownAway() - this.previousRowIngestionMetersTotals.getThrownAway();
        if (thrownAway > 0L) {
            log.warn("[%,d] events thrown away. Possible causes: null events, events filtered out by transformSpec, or events outside earlyMessageRejectionPeriod / lateMessageRejectionPeriod.", new Object[]{thrownAway});
        }
        builder.setDimensionIfNotNull("tags", this.metricTags);
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/events/thrownAway", (Number)thrownAway));
        long unparseable = rowIngestionMetersTotals.getUnparseable() - this.previousRowIngestionMetersTotals.getUnparseable();
        if (unparseable > 0L) {
            log.error("[%,d] unparseable events discarded. Turn on debug logging to see exception stack trace.", new Object[]{unparseable});
        }
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/events/unparseable", (Number)unparseable));
        long processedWithError = rowIngestionMetersTotals.getProcessedWithError() - this.previousRowIngestionMetersTotals.getProcessedWithError();
        if (processedWithError > 0L) {
            log.error("[%,d] events processed with errors! Set logParseExceptions to true in the ingestion spec to log these errors.", new Object[]{processedWithError});
        }
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/events/processedWithError", (Number)processedWithError));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/events/processed", (Number)(rowIngestionMetersTotals.getProcessed() - this.previousRowIngestionMetersTotals.getProcessed())));
        long dedup = metrics.dedup() - this.previousSegmentGenerationMetrics.dedup();
        if (dedup > 0L) {
            log.warn("[%,d] duplicate events!", new Object[]{dedup});
        }
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/events/duplicate", (Number)dedup));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/input/bytes", (Number)(rowIngestionMetersTotals.getProcessedBytes() - this.previousRowIngestionMetersTotals.getProcessedBytes())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/rows/output", (Number)(metrics.rowOutput() - this.previousSegmentGenerationMetrics.rowOutput())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/persists/count", (Number)(metrics.numPersists() - this.previousSegmentGenerationMetrics.numPersists())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/persists/time", (Number)(metrics.persistTimeMillis() - this.previousSegmentGenerationMetrics.persistTimeMillis())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/persists/cpu", (Number)(metrics.persistCpuTime() - this.previousSegmentGenerationMetrics.persistCpuTime())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/persists/backPressure", (Number)(metrics.persistBackPressureMillis() - this.previousSegmentGenerationMetrics.persistBackPressureMillis())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/persists/failed", (Number)(metrics.failedPersists() - this.previousSegmentGenerationMetrics.failedPersists())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/handoff/failed", (Number)(metrics.failedHandoffs() - this.previousSegmentGenerationMetrics.failedHandoffs())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/merge/time", (Number)(metrics.mergeTimeMillis() - this.previousSegmentGenerationMetrics.mergeTimeMillis())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/merge/cpu", (Number)(metrics.mergeCpuTime() - this.previousSegmentGenerationMetrics.mergeCpuTime())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/handoff/count", (Number)(metrics.handOffCount() - this.previousSegmentGenerationMetrics.handOffCount())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/sink/count", (Number)metrics.sinkCount()));
        long messageGap = metrics.messageGap();
        if (messageGap >= 0L) {
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/events/messageGap", (Number)messageGap));
        }
        if ((maxSegmentHandoffTime = metrics.maxSegmentHandoffTime()) >= 0L) {
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/handoff/time", (Number)maxSegmentHandoffTime));
        }
        this.previousRowIngestionMetersTotals = rowIngestionMetersTotals;
        this.previousSegmentGenerationMetrics = metrics;
        return true;
    }
}

