/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import org.apache.druid.data.input.InputRow;
import org.apache.druid.indexing.common.task.SequenceNameFunction;
import org.apache.druid.indexing.common.task.ShardSpecs;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.joda.time.Interval;

public class NonLinearlyPartitionedSequenceNameFunction
implements SequenceNameFunction {
    private final String baseSequenceName;
    private final ShardSpecs shardSpecs;

    public NonLinearlyPartitionedSequenceNameFunction(String baseSequenceName, ShardSpecs shardSpecs) {
        this.baseSequenceName = baseSequenceName;
        this.shardSpecs = shardSpecs;
    }

    @Override
    public String getSequenceName(Interval interval, InputRow inputRow) {
        return this.getSequenceName(interval, this.shardSpecs.getShardSpec(interval, inputRow));
    }

    public String getSequenceName(Interval interval, BucketNumberedShardSpec<?> bucket) {
        return this.baseSequenceName + "_" + interval + "_" + bucket.getBucketId();
    }
}

