/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteStreams;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.math.IntMath;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.indexer.RunnerTaskState;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskStorageDirTracker;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.tasklogs.LogUtils;
import org.apache.druid.indexing.overlord.BaseRestorableTaskRunner;
import org.apache.druid.indexing.overlord.PortFinder;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.indexing.overlord.autoscaling.ScalingStats;
import org.apache.druid.indexing.overlord.config.ForkingTaskRunnerConfig;
import org.apache.druid.indexing.worker.config.WorkerConfig;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.log.StartupLoggingConfig;
import org.apache.druid.server.metrics.WorkerTaskCountStatsProvider;
import org.apache.druid.tasklogs.TaskLogPusher;
import org.apache.druid.tasklogs.TaskLogStreamer;
import org.apache.druid.utils.JvmUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class ForkingTaskRunner
extends BaseRestorableTaskRunner<ForkingTaskRunnerWorkItem>
implements TaskLogStreamer,
WorkerTaskCountStatsProvider {
    private static final EmittingLogger LOGGER = new EmittingLogger(ForkingTaskRunner.class);
    private static final String CHILD_PROPERTY_PREFIX = "druid.indexer.fork.property.";
    private static final List<String> STRONG_ENCAPSULATION_PROPERTIES = ImmutableList.of((Object)"--add-exports=java.base/jdk.internal.misc=ALL-UNNAMED", (Object)"--add-exports=java.base/jdk.internal.ref=ALL-UNNAMED", (Object)"--add-opens=java.base/java.nio=ALL-UNNAMED", (Object)"--add-opens=java.base/sun.nio.ch=ALL-UNNAMED", (Object)"--add-opens=java.base/jdk.internal.ref=ALL-UNNAMED", (Object)"--add-opens=java.base/java.io=ALL-UNNAMED", (Object)"--add-opens=java.base/java.lang=ALL-UNNAMED", (Object)"--add-opens=jdk.management/com.sun.management.internal=ALL-UNNAMED");
    private final ForkingTaskRunnerConfig config;
    private final Properties props;
    private final TaskLogPusher taskLogPusher;
    private final DruidNode node;
    private final ListeningExecutorService exec;
    private final PortFinder portFinder;
    private final StartupLoggingConfig startupLoggingConfig;
    private final WorkerConfig workerConfig;
    private volatile int numProcessorsPerTask = -1;
    private volatile boolean stopping = false;
    private final AtomicLong lastReportedFailedTaskCount = new AtomicLong();
    private final AtomicLong failedTaskCount = new AtomicLong();
    private final AtomicLong successfulTaskCount = new AtomicLong();
    private final AtomicLong lastReportedSuccessfulTaskCount = new AtomicLong();

    @Inject
    public ForkingTaskRunner(ForkingTaskRunnerConfig config, TaskConfig taskConfig, WorkerConfig workerConfig, Properties props, TaskLogPusher taskLogPusher, ObjectMapper jsonMapper, @Self DruidNode node, StartupLoggingConfig startupLoggingConfig, TaskStorageDirTracker dirTracker) {
        super(jsonMapper, taskConfig, dirTracker);
        this.config = config;
        this.props = props;
        this.taskLogPusher = taskLogPusher;
        this.node = node;
        this.portFinder = new PortFinder(config.getStartPort(), config.getEndPort(), config.getPorts());
        this.startupLoggingConfig = startupLoggingConfig;
        this.workerConfig = workerConfig;
        this.exec = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)workerConfig.getCapacity(), (String)"forking-task-runner-%d"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<TaskStatus> run(final Task task) {
        ConcurrentHashMap concurrentHashMap = this.tasks;
        synchronized (concurrentHashMap) {
            this.tasks.computeIfAbsent(task.getId(), k -> new ForkingTaskRunnerWorkItem(task, (ListenableFuture<TaskStatus>)this.exec.submit((Callable)new Callable<TaskStatus>(){

                /*
                 * Exception decompiling
                 */
                @Override
                public TaskStatus call() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            })));
            this.saveRunningTasks();
            return ((ForkingTaskRunnerWorkItem)this.tasks.get(task.getId())).getResult();
        }
    }

    @VisibleForTesting
    ProcessHolder runTaskProcess(List<String> command, File logFile, TaskLocation taskLocation) throws IOException {
        return new ProcessHolder(new ProcessBuilder((List<String>)ImmutableList.copyOf(command)).redirectErrorStream(true).start(), logFile, taskLocation);
    }

    @VisibleForTesting
    int waitForTaskProcessToComplete(Task task, ProcessHolder processHolder, File logFile, File reportsFile) throws IOException, InterruptedException {
        ByteSink logSink = Files.asByteSink((File)logFile, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND});
        String priorThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(StringUtils.format((String)"%s-[%s]", (Object[])new Object[]{priorThreadName, task.getId()}));
        try {
            int n;
            block10: {
                OutputStream toLogfile = logSink.openStream();
                try {
                    ByteStreams.copy((InputStream)processHolder.process.getInputStream(), (OutputStream)toLogfile);
                    n = processHolder.process.waitFor();
                    if (toLogfile == null) break block10;
                }
                catch (Throwable throwable) {
                    if (toLogfile != null) {
                        try {
                            toLogfile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                toLogfile.close();
            }
            return n;
        }
        finally {
            Thread.currentThread().setName(priorThreadName);
            this.taskLogPusher.pushTaskLog(task.getId(), logFile);
            if (reportsFile.exists()) {
                this.taskLogPusher.pushTaskReports(task.getId(), reportsFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStop
    public void stop() {
        block12: {
            this.stopping = true;
            this.exec.shutdown();
            ConcurrentHashMap concurrentHashMap = this.tasks;
            synchronized (concurrentHashMap) {
                for (ForkingTaskRunnerWorkItem taskWorkItem : this.tasks.values()) {
                    this.shutdownTaskProcess(taskWorkItem);
                }
            }
            DateTime start = DateTimes.nowUtc();
            long timeout = new Interval((ReadableInstant)start, (ReadablePeriod)this.taskConfig.getGracefulShutdownTimeout()).toDurationMillis();
            LOGGER.info("Waiting up to %,dms for shutdown.", new Object[]{timeout});
            if (timeout > 0L) {
                try {
                    ImmutableSet stillRunning;
                    boolean terminated = this.exec.awaitTermination(timeout, TimeUnit.MILLISECONDS);
                    long elapsed = System.currentTimeMillis() - start.getMillis();
                    if (terminated) {
                        LOGGER.info("Finished stopping in %,dms.", new Object[]{elapsed});
                        break block12;
                    }
                    ConcurrentHashMap concurrentHashMap2 = this.tasks;
                    synchronized (concurrentHashMap2) {
                        stillRunning = ImmutableSet.copyOf((Collection)this.tasks.keySet());
                    }
                    LOGGER.makeAlert("Failed to stop forked tasks", new Object[0]).addData("stillRunning", (Object)stillRunning).addData("elapsed", (Object)elapsed).emit();
                    LOGGER.warn("Executor failed to stop after %,dms, not waiting for it! Tasks still running: [%s]", new Object[]{elapsed, Joiner.on((String)"; ").join((Iterable)stillRunning)});
                }
                catch (InterruptedException e) {
                    LOGGER.warn((Throwable)e, "Interrupted while waiting for executor to finish.", new Object[0]);
                    Thread.currentThread().interrupt();
                }
            } else {
                LOGGER.warn("Ran out of time, not waiting for executor to finish!", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(String taskid, String reason) {
        LOGGER.info("Shutdown [%s] because: [%s]", new Object[]{taskid, reason});
        ConcurrentHashMap concurrentHashMap = this.tasks;
        synchronized (concurrentHashMap) {
            ForkingTaskRunnerWorkItem taskInfo = (ForkingTaskRunnerWorkItem)this.tasks.get(taskid);
            if (taskInfo == null) {
                LOGGER.info("Ignoring request to cancel unknown task: %s", new Object[]{taskid});
                return;
            }
            taskInfo.shutdown = true;
            this.shutdownTaskProcess(taskInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<TaskRunnerWorkItem> getRunningTasks() {
        ConcurrentHashMap concurrentHashMap = this.tasks;
        synchronized (concurrentHashMap) {
            ArrayList<TaskRunnerWorkItem> ret = new ArrayList<TaskRunnerWorkItem>();
            for (ForkingTaskRunnerWorkItem taskWorkItem : this.tasks.values()) {
                if (taskWorkItem.processHolder == null) continue;
                ret.add(taskWorkItem);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<TaskRunnerWorkItem> getPendingTasks() {
        ConcurrentHashMap concurrentHashMap = this.tasks;
        synchronized (concurrentHashMap) {
            ArrayList<TaskRunnerWorkItem> ret = new ArrayList<TaskRunnerWorkItem>();
            for (ForkingTaskRunnerWorkItem taskWorkItem : this.tasks.values()) {
                if (taskWorkItem.processHolder != null) continue;
                ret.add(taskWorkItem);
            }
            return ret;
        }
    }

    @Override
    @Nullable
    public RunnerTaskState getRunnerTaskState(String taskId) {
        ForkingTaskRunnerWorkItem workItem = (ForkingTaskRunnerWorkItem)this.tasks.get(taskId);
        if (workItem == null) {
            return null;
        }
        if (workItem.processHolder == null) {
            return RunnerTaskState.PENDING;
        }
        if (workItem.processHolder.process.isAlive()) {
            return RunnerTaskState.RUNNING;
        }
        return RunnerTaskState.NONE;
    }

    @Override
    public Optional<ScalingStats> getScalingStats() {
        return Optional.absent();
    }

    @Override
    @LifecycleStart
    public void start() {
        this.setNumProcessorsPerTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<InputStream> streamTaskLog(String taskid, long offset) throws IOException {
        ProcessHolder processHolder;
        ConcurrentHashMap concurrentHashMap = this.tasks;
        synchronized (concurrentHashMap) {
            ForkingTaskRunnerWorkItem taskWorkItem = (ForkingTaskRunnerWorkItem)this.tasks.get(taskid);
            if (taskWorkItem == null || taskWorkItem.processHolder == null) {
                return Optional.absent();
            }
            processHolder = taskWorkItem.processHolder;
        }
        return Optional.of((Object)LogUtils.streamFile(processHolder.logFile, offset));
    }

    private void shutdownTaskProcess(ForkingTaskRunnerWorkItem taskInfo) {
        if (taskInfo.processHolder != null) {
            LOGGER.info("Closing output stream to task[%s].", new Object[]{taskInfo.getTask().getId()});
            try {
                taskInfo.processHolder.process.getOutputStream().close();
            }
            catch (Exception e) {
                LOGGER.warn((Throwable)e, "Failed to close stdout to task[%s]. Destroying task.", new Object[]{taskInfo.getTask().getId()});
                taskInfo.processHolder.process.destroy();
            }
        }
    }

    public static String getMaskedCommand(List<String> maskedProperties, List<String> command) {
        HashSet maskedPropertiesSet = Sets.newHashSet(maskedProperties);
        Iterator maskedIterator = command.stream().map(element -> {
            String[] splits = element.split("=", 2);
            if (splits.length == 2) {
                for (String masked : maskedPropertiesSet) {
                    if (!splits[0].contains(masked)) continue;
                    return StringUtils.format((String)"%s=%s", (Object[])new Object[]{splits[0], "<masked>"});
                }
            }
            return element;
        }).iterator();
        return Joiner.on((String)" ").join(maskedIterator);
    }

    @Override
    public Map<String, Long> getTotalTaskSlotCount() {
        return ImmutableMap.of((Object)this.workerConfig.getCategory(), (Object)this.getTotalTaskSlotCountLong());
    }

    public long getTotalTaskSlotCountLong() {
        return this.workerConfig.getCapacity();
    }

    @Override
    public Map<String, Long> getIdleTaskSlotCount() {
        return ImmutableMap.of((Object)this.workerConfig.getCategory(), (Object)Math.max(this.getTotalTaskSlotCountLong() - this.getUsedTaskSlotCountLong(), 0L));
    }

    @Override
    public Map<String, Long> getUsedTaskSlotCount() {
        return ImmutableMap.of((Object)this.workerConfig.getCategory(), (Object)this.portFinder.findUsedPortCount());
    }

    public long getUsedTaskSlotCountLong() {
        return this.portFinder.findUsedPortCount();
    }

    @Override
    public Map<String, Long> getLazyTaskSlotCount() {
        return ImmutableMap.of((Object)this.workerConfig.getCategory(), (Object)0L);
    }

    @Override
    public Map<String, Long> getBlacklistedTaskSlotCount() {
        return ImmutableMap.of((Object)this.workerConfig.getCategory(), (Object)0L);
    }

    public Long getWorkerFailedTaskCount() {
        long failedTaskCount = this.failedTaskCount.get();
        long lastReportedFailedTaskCount = this.lastReportedFailedTaskCount.get();
        this.lastReportedFailedTaskCount.set(failedTaskCount);
        return failedTaskCount - lastReportedFailedTaskCount;
    }

    public Long getWorkerIdleTaskSlotCount() {
        return Math.max(this.getTotalTaskSlotCountLong() - this.getUsedTaskSlotCountLong(), 0L);
    }

    public Long getWorkerUsedTaskSlotCount() {
        return this.portFinder.findUsedPortCount();
    }

    public Long getWorkerTotalTaskSlotCount() {
        return this.getTotalTaskSlotCountLong();
    }

    public String getWorkerCategory() {
        return this.workerConfig.getCategory();
    }

    public String getWorkerVersion() {
        return this.workerConfig.getVersion();
    }

    public Long getWorkerSuccessfulTaskCount() {
        long successfulTaskCount = this.successfulTaskCount.get();
        long lastReportedSuccessfulTaskCount = this.lastReportedSuccessfulTaskCount.get();
        this.lastReportedSuccessfulTaskCount.set(successfulTaskCount);
        return successfulTaskCount - lastReportedSuccessfulTaskCount;
    }

    @VisibleForTesting
    void setNumProcessorsPerTask() {
        int availableProcessors = JvmUtils.getRuntimeInfo().getAvailableProcessors();
        this.numProcessorsPerTask = Math.max(1, IntMath.divide((int)availableProcessors, (int)this.workerConfig.getCapacity(), (RoundingMode)RoundingMode.CEILING));
    }

    @VisibleForTesting
    static int getNextAttemptID(File taskDir) {
        File attemptDir = new File(taskDir, "attempt");
        try {
            FileUtils.mkdirp((File)attemptDir);
        }
        catch (IOException e) {
            throw new ISE("Error creating directory", new Object[]{e});
        }
        int maxAttempt = Arrays.stream(attemptDir.listFiles(File::isDirectory)).mapToInt(x -> Integer.parseInt(x.getName())).max().orElse(0);
        File attempt = new File(attemptDir, String.valueOf(maxAttempt + 1));
        try {
            FileUtils.mkdirp((File)attempt);
        }
        catch (IOException e) {
            throw new ISE("Error creating directory", new Object[]{e});
        }
        return maxAttempt + 1;
    }

    public static class CommandListBuilder {
        ArrayList<String> commandList = new ArrayList();

        public CommandListBuilder add(String arg) {
            this.commandList.add(arg);
            return this;
        }

        public CommandListBuilder addSystemProperty(String property, int value) {
            return this.addSystemProperty(property, String.valueOf(value));
        }

        public CommandListBuilder addSystemProperty(String property, long value) {
            return this.addSystemProperty(property, String.valueOf(value));
        }

        public CommandListBuilder addSystemProperty(String property, boolean value) {
            return this.addSystemProperty(property, String.valueOf(value));
        }

        public CommandListBuilder addSystemProperty(String property, String value) {
            return this.add(StringUtils.format((String)"-D%s=%s", (Object[])new Object[]{property, value}));
        }

        public CommandListBuilder addAll(Iterable<String> args) {
            for (String arg : args) {
                this.add(arg);
            }
            return this;
        }

        public ArrayList<String> getCommandList() {
            return this.commandList;
        }
    }

    public static class ProcessHolder {
        private final Process process;
        private final File logFile;
        private final TaskLocation location;

        public ProcessHolder(Process process, File logFile, TaskLocation location) {
            this.process = process;
            this.logFile = logFile;
            this.location = location;
        }

        private void registerWithCloser(Closer closer) {
            closer.register((Closeable)this.process.getInputStream());
            closer.register((Closeable)this.process.getOutputStream());
        }

        private void shutdown() {
            this.process.destroy();
        }
    }

    protected static class ForkingTaskRunnerWorkItem
    extends TaskRunnerWorkItem {
        private final Task task;
        private volatile boolean shutdown = false;
        private volatile ProcessHolder processHolder = null;

        private ForkingTaskRunnerWorkItem(Task task, ListenableFuture<TaskStatus> statusFuture) {
            super(task.getId(), statusFuture);
            this.task = task;
        }

        public Task getTask() {
            return this.task;
        }

        @Override
        public TaskLocation getLocation() {
            if (this.processHolder == null) {
                return TaskLocation.unknown();
            }
            return this.processHolder.location;
        }

        @Override
        public String getTaskType() {
            return this.task.getType();
        }

        @Override
        public String getDataSource() {
            return this.task.getDataSource();
        }
    }
}

