/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.http;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Collection;
import java.util.Collections;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.error.NotFound;
import org.apache.druid.indexing.compact.CompactionScheduler;
import org.apache.druid.server.compaction.CompactionProgressResponse;
import org.apache.druid.server.compaction.CompactionStatusResponse;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.CompactionSupervisorConfig;
import org.apache.druid.server.http.ServletResourceUtils;
import org.apache.druid.server.http.security.StateResourceFilter;

@Path(value="/druid/indexer/v1/compaction")
public class OverlordCompactionResource {
    private final CompactionScheduler scheduler;
    private final CompactionSupervisorConfig supervisorConfig;

    @Inject
    public OverlordCompactionResource(CompactionSupervisorConfig supervisorConfig, CompactionScheduler scheduler) {
        this.scheduler = scheduler;
        this.supervisorConfig = supervisorConfig;
    }

    @GET
    @Path(value="/isSupervisorEnabled")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response isCompactionSupervisorEnabled() {
        return Response.ok((Object)this.supervisorConfig.isEnabled()).build();
    }

    @GET
    @Path(value="/progress")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getCompactionProgress(@QueryParam(value="dataSource") String dataSource) {
        if (!this.supervisorConfig.isEnabled()) {
            return this.buildErrorResponseIfSchedulerDisabled();
        }
        if (dataSource == null || dataSource.isEmpty()) {
            return ServletResourceUtils.buildErrorResponseFrom((DruidException)InvalidInput.exception((String)"No DataSource specified", (Object[])new Object[0]));
        }
        AutoCompactionSnapshot snapshot = this.scheduler.getCompactionSnapshot(dataSource);
        if (snapshot == null) {
            return ServletResourceUtils.buildErrorResponseFrom((DruidException)NotFound.exception((String)"Unknown DataSource", (Object[])new Object[0]));
        }
        return Response.ok((Object)new CompactionProgressResponse(snapshot.getBytesAwaitingCompaction())).build();
    }

    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getCompactionSnapshots(@QueryParam(value="dataSource") String dataSource) {
        Collection<AutoCompactionSnapshot> snapshots;
        if (!this.supervisorConfig.isEnabled()) {
            return this.buildErrorResponseIfSchedulerDisabled();
        }
        if (dataSource == null || dataSource.isEmpty()) {
            snapshots = this.scheduler.getAllCompactionSnapshots().values();
        } else {
            AutoCompactionSnapshot autoCompactionSnapshot = this.scheduler.getCompactionSnapshot(dataSource);
            if (autoCompactionSnapshot == null) {
                return ServletResourceUtils.buildErrorResponseFrom((DruidException)NotFound.exception((String)"Unknown DataSource", (Object[])new Object[0]));
            }
            snapshots = Collections.singleton(autoCompactionSnapshot);
        }
        return Response.ok((Object)new CompactionStatusResponse(snapshots)).build();
    }

    @POST
    @Path(value="/simulate")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response simulateRunWithConfigUpdate(ClusterCompactionConfig updatePayload) {
        return Response.ok().entity((Object)this.scheduler.simulateRunWithConfigUpdate(updatePayload)).build();
    }

    private Response buildErrorResponseIfSchedulerDisabled() {
        String msg = "Compaction Supervisors are disabled on the Overlord. Use Coordinator APIs to fetch compaction status.";
        return ServletResourceUtils.buildErrorResponseFrom((DruidException)DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.UNSUPPORTED).build("Compaction Supervisors are disabled on the Overlord. Use Coordinator APIs to fetch compaction status.", new Object[0]));
    }
}

