/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;

class EnumArgument<T extends Enum<T>>
implements Argument {
    private final T value;

    public EnumArgument(T value) {
        this.value = value;
    }

    @Override
    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        if (this.value == null) {
            statement.setNull(position, 12);
        } else {
            statement.setString(position, ((Enum)this.value).name());
        }
    }

    public String toString() {
        return this.value != null ? ((Enum)this.value).toString() : "<null>";
    }
}

