/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.lang.reflect.Method;
import org.skife.jdbi.cglib.proxy.MethodProxy;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionIsolationLevel;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.sqlobject.HandleDing;
import org.skife.jdbi.v2.sqlobject.Handler;
import org.skife.jdbi.v2.sqlobject.Transaction;

class PassThroughTransactionHandler
implements Handler {
    private final TransactionIsolationLevel isolation;

    PassThroughTransactionHandler(Method m, Transaction tx) {
        this.isolation = tx.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(HandleDing ding, final Object target, final Object[] args, final MethodProxy mp) {
        ding.retain("pass-through-transaction");
        try {
            Handle h = ding.getHandle();
            if (this.isolation == TransactionIsolationLevel.INVALID_LEVEL) {
                Object object = h.inTransaction(new TransactionCallback<Object>(){

                    @Override
                    public Object inTransaction(Handle conn, TransactionStatus status) throws Exception {
                        try {
                            return mp.invokeSuper(target, args);
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof Exception) {
                                throw (Exception)throwable;
                            }
                            throw new RuntimeException(throwable);
                        }
                    }
                });
                return object;
            }
            Object object = h.inTransaction(this.isolation, new TransactionCallback<Object>(){

                @Override
                public Object inTransaction(Handle conn, TransactionStatus status) throws Exception {
                    try {
                        return mp.invokeSuper(target, args);
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof Exception) {
                            throw (Exception)throwable;
                        }
                        throw new RuntimeException(throwable);
                    }
                }
            });
            return object;
        }
        finally {
            ding.release("pass-through-transaction");
        }
    }
}

