/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.github.rvesse.airline.annotations.Command;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.druid.cli.QueryJettyServerInitializer;
import org.apache.druid.cli.ServerRunnable;
import org.apache.druid.client.BrokerSegmentWatcherConfig;
import org.apache.druid.client.BrokerServerView;
import org.apache.druid.client.CachingClusteredClient;
import org.apache.druid.client.DirectDruidClientFactory;
import org.apache.druid.client.HttpServerInventoryViewResource;
import org.apache.druid.client.InternalQueryConfig;
import org.apache.druid.client.QueryableDruidServer;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.selector.CustomTierSelectorStrategyConfig;
import org.apache.druid.client.selector.ServerSelectorStrategy;
import org.apache.druid.client.selector.TierSelectorStrategy;
import org.apache.druid.curator.ZkEnablementConfig;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.BrokerProcessingModule;
import org.apache.druid.guice.BrokerServiceModule;
import org.apache.druid.guice.CacheModule;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JoinableFactoryModule;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LegacyBrokerParallelMergeConfigModule;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.QueryRunnerFactoryModule;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.guice.SegmentWranglerModule;
import org.apache.druid.guice.ServerTypeConfig;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.RetryQueryRunnerConfig;
import org.apache.druid.query.lookup.LookupModule;
import org.apache.druid.server.BrokerQueryResource;
import org.apache.druid.server.ClientInfoResource;
import org.apache.druid.server.ClientQuerySegmentWalker;
import org.apache.druid.server.ResponseContextConfig;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.SubqueryGuardrailHelper;
import org.apache.druid.server.SubqueryGuardrailHelperProvider;
import org.apache.druid.server.coordination.SegmentBootstrapper;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordination.ZkCoordinator;
import org.apache.druid.server.http.BrokerResource;
import org.apache.druid.server.http.HistoricalResource;
import org.apache.druid.server.http.SegmentListerResource;
import org.apache.druid.server.http.SelfDiscoveryResource;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.metrics.QueryCountStatsProvider;
import org.apache.druid.server.metrics.SubqueryCountStatsProvider;
import org.apache.druid.sql.calcite.schema.MetadataSegmentView;
import org.apache.druid.sql.guice.SqlModule;
import org.apache.druid.storage.local.LocalTmpStorageConfig;
import org.apache.druid.timeline.PruneLoadSpec;
import org.eclipse.jetty.server.Server;

@Command(name="broker", description="Runs a broker node, see https://druid.apache.org/docs/latest/Broker.html for a description")
public class CliBroker
extends ServerRunnable {
    private static final Logger log = new Logger(CliBroker.class);
    private boolean isZkEnabled = true;

    public CliBroker() {
        super(log);
    }

    @Inject
    public void configure(Properties properties) {
        this.isZkEnabled = ZkEnablementConfig.isEnabled((Properties)properties);
    }

    @Override
    protected Set<NodeRole> getNodeRoles(Properties properties) {
        return ImmutableSet.of((Object)NodeRole.BROKER);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new LegacyBrokerParallelMergeConfigModule(), (Object)new BrokerProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), (Object)new SegmentWranglerModule(), (Object)new JoinableFactoryModule(), (Object)new BrokerServiceModule(), binder -> {
            CliBroker.validateCentralizedDatasourceSchemaConfig(this.getProperties());
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/broker");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8082);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(8282);
            binder.bindConstant().annotatedWith(PruneLoadSpec.class).to(true);
            binder.bind(ResponseContextConfig.class).toInstance((Object)ResponseContextConfig.newConfig((boolean)false));
            binder.bind(CachingClusteredClient.class).in(LazySingleton.class);
            LifecycleModule.register((Binder)binder, BrokerServerView.class);
            LifecycleModule.register((Binder)binder, MetadataSegmentView.class);
            binder.bind(TimelineServerView.class).to(BrokerServerView.class).in(LazySingleton.class);
            binder.bind(QueryableDruidServer.Maker.class).to(DirectDruidClientFactory.class).in(LazySingleton.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.cache", CacheConfig.class);
            binder.install((Module)new CacheModule());
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.select", TierSelectorStrategy.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.select.tier.custom", CustomTierSelectorStrategyConfig.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.balancer", ServerSelectorStrategy.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.retryPolicy", RetryQueryRunnerConfig.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.segment", BrokerSegmentWatcherConfig.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.internal.query.config", InternalQueryConfig.class);
            binder.bind(QuerySegmentWalker.class).to(ClientQuerySegmentWalker.class).in(LazySingleton.class);
            binder.bind(JettyServerInitializer.class).to(QueryJettyServerInitializer.class).in(LazySingleton.class);
            binder.bind(BrokerQueryResource.class).in(LazySingleton.class);
            Jerseys.addResource((Binder)binder, BrokerQueryResource.class);
            binder.bind(SubqueryGuardrailHelper.class).toProvider(SubqueryGuardrailHelperProvider.class);
            binder.bind(QueryCountStatsProvider.class).to(BrokerQueryResource.class).in(LazySingleton.class);
            binder.bind(SubqueryCountStatsProvider.class).toInstance((Object)new SubqueryCountStatsProvider());
            Jerseys.addResource((Binder)binder, BrokerResource.class);
            Jerseys.addResource((Binder)binder, ClientInfoResource.class);
            LifecycleModule.register((Binder)binder, BrokerQueryResource.class);
            Jerseys.addResource((Binder)binder, HttpServerInventoryViewResource.class);
            LifecycleModule.register((Binder)binder, Server.class);
            binder.bind(SegmentManager.class).in(LazySingleton.class);
            binder.bind(ZkCoordinator.class).in(ManageLifecycle.class);
            binder.bind(ServerTypeConfig.class).toInstance((Object)new ServerTypeConfig(ServerType.BROKER));
            Jerseys.addResource((Binder)binder, HistoricalResource.class);
            Jerseys.addResource((Binder)binder, SegmentListerResource.class);
            if (this.isZkEnabled) {
                LifecycleModule.register((Binder)binder, ZkCoordinator.class);
            }
            LifecycleModule.register((Binder)binder, SegmentBootstrapper.class);
            CliBroker.bindAnnouncer(binder, ServerRunnable.DiscoverySideEffectsProvider.withLegacyAnnouncer());
            Jerseys.addResource((Binder)binder, SelfDiscoveryResource.class);
            LifecycleModule.registerKey((Binder)binder, (Key)Key.get(SelfDiscoveryResource.class));
            binder.bind(LocalTmpStorageConfig.class).toProvider((Provider)new LocalTmpStorageConfig.DefaultLocalTmpStorageConfigProvider("broker")).in(LazySingleton.class);
        }, (Object)new LookupModule(), (Object)new SqlModule());
    }
}

