/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli.convert;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.cli.convert.PropertyConverter;
import org.apache.druid.java.util.common.StringUtils;

public class DatabasePropertiesConverter
implements PropertyConverter {
    private final List<String> tableProperties = Lists.newArrayList((Object[])new String[]{"druid.database.segmentTable", "druid.database.configTable", "druid.database.ruleTable", "druid.database.taskLockTable", "druid.database.taskLogTable", "druid.database.taskTable"});
    private AtomicBoolean ran = new AtomicBoolean(false);

    @Override
    public boolean canHandle(String property) {
        return this.tableProperties.contains(property) && !this.ran.get();
    }

    @Override
    public Map<String, String> convert(Properties properties) {
        if (!this.ran.getAndSet(true)) {
            String tablePrefix = properties.getProperty("druid.database.segmentTable");
            tablePrefix = tablePrefix == null ? "druid" : tablePrefix.split("_")[0];
            LinkedHashMap retVal = Maps.newLinkedHashMap();
            retVal.put("druid.db.tables.base", tablePrefix);
            this.addIfNotDefault(properties, tablePrefix, retVal, "druid.database.segmentTable", "segments");
            this.addIfNotDefault(properties, tablePrefix, retVal, "druid.database.configTable", "config");
            this.addIfNotDefault(properties, tablePrefix, retVal, "druid.database.ruleTable", "rules");
            this.addIfNotDefault(properties, tablePrefix, retVal, "druid.database.taskTable", "tasks");
            this.addIfNotDefault(properties, tablePrefix, retVal, "druid.database.taskLockTable", "taskLock");
            this.addIfNotDefault(properties, tablePrefix, retVal, "druid.database.taskLogTable", "taskLog");
            return retVal;
        }
        return ImmutableMap.of();
    }

    private void addIfNotDefault(Properties properties, String tablePrefix, Map<String, String> retVal, String property, String tablename) {
        String value = properties.getProperty(property);
        if (value != null && !value.equals(StringUtils.format((String)"%s_%s", (Object[])new Object[]{tablePrefix, tablename}))) {
            retVal.put(StringUtils.format((String)"druid.db.tables.%s", (Object[])new Object[]{tablename}), value);
        }
    }
}

