/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.discovery;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.kubernetes.client.util.Watch;
import java.io.Closeable;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.discovery.BaseNodeRoleWatcher;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.k8s.discovery.DiscoveryDruidNodeAndResourceVersion;
import org.apache.druid.k8s.discovery.DiscoveryDruidNodeList;
import org.apache.druid.k8s.discovery.K8sApiClient;
import org.apache.druid.k8s.discovery.K8sDiscoveryConfig;
import org.apache.druid.k8s.discovery.K8sDruidNodeAnnouncer;
import org.apache.druid.k8s.discovery.PodInfo;
import org.apache.druid.k8s.discovery.WatchResult;
import org.apache.druid.server.DruidNode;
import org.apache.druid.utils.CloseableUtils;

@ManageLifecycle
public class K8sDruidNodeDiscoveryProvider
extends DruidNodeDiscoveryProvider {
    private static final Logger LOGGER = new Logger(K8sDruidNodeDiscoveryProvider.class);
    private final PodInfo podInfo;
    private final K8sDiscoveryConfig discoveryConfig;
    private final K8sApiClient k8sApiClient;
    private ScheduledExecutorService listenerExecutor;
    private final ConcurrentHashMap<NodeRole, NodeRoleWatcher> nodeTypeWatchers = new ConcurrentHashMap();
    private final LifecycleLock lifecycleLock = new LifecycleLock();
    private final long watcherErrorRetryWaitMS;

    @Inject
    public K8sDruidNodeDiscoveryProvider(PodInfo podInfo, K8sDiscoveryConfig discoveryConfig, K8sApiClient k8sApiClient) {
        this(podInfo, discoveryConfig, k8sApiClient, 10000L);
    }

    @VisibleForTesting
    K8sDruidNodeDiscoveryProvider(PodInfo podInfo, K8sDiscoveryConfig discoveryConfig, K8sApiClient k8sApiClient, long watcherErrorRetryWaitMS) {
        this.podInfo = podInfo;
        this.discoveryConfig = discoveryConfig;
        this.k8sApiClient = k8sApiClient;
        this.watcherErrorRetryWaitMS = watcherErrorRetryWaitMS;
    }

    public BooleanSupplier getForNode(DruidNode node, NodeRole nodeRole) {
        return () -> this.k8sApiClient.listPods(this.podInfo.getPodNamespace(), K8sDruidNodeAnnouncer.getLabelSelectorForNode(this.discoveryConfig, nodeRole, node), nodeRole).getDruidNodes().containsKey(node.getHostAndPortToUse());
    }

    public DruidNodeDiscovery getForNodeRole(NodeRole nodeType) {
        return this.getForNodeRole(nodeType, true);
    }

    @VisibleForTesting
    NodeRoleWatcher getForNodeRole(NodeRole nodeType, boolean startAfterCreation) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        return this.nodeTypeWatchers.computeIfAbsent(nodeType, nType -> {
            LOGGER.info("Creating NodeRoleWatcher for role[%s].", new Object[]{nType});
            NodeRoleWatcher nodeRoleWatcher = new NodeRoleWatcher(this.listenerExecutor, (NodeRole)nType, this.podInfo, this.discoveryConfig, this.k8sApiClient, this.watcherErrorRetryWaitMS);
            if (startAfterCreation) {
                nodeRoleWatcher.start();
            }
            LOGGER.info("Created NodeRoleWatcher for role[%s].", new Object[]{nType});
            return nodeRoleWatcher;
        });
    }

    @LifecycleStart
    public void start() {
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("can't start.", new Object[0]);
        }
        try {
            LOGGER.info("starting", new Object[0]);
            this.listenerExecutor = Execs.scheduledSingleThreaded((String)"K8sDruidNodeDiscoveryProvider-ListenerExecutor");
            LOGGER.info("started", new Object[0]);
            this.lifecycleLock.started();
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @LifecycleStop
    public void stop() {
        if (!this.lifecycleLock.canStop()) {
            throw new ISE("can't stop.", new Object[0]);
        }
        LOGGER.info("stopping", new Object[0]);
        for (NodeRoleWatcher watcher : this.nodeTypeWatchers.values()) {
            watcher.stop();
        }
        this.listenerExecutor.shutdownNow();
        LOGGER.info("stopped", new Object[0]);
    }

    @VisibleForTesting
    static class NodeRoleWatcher
    implements DruidNodeDiscovery {
        private static final Logger LOGGER = new Logger(NodeRoleWatcher.class);
        private final PodInfo podInfo;
        private final K8sDiscoveryConfig discoveryConfig;
        private final K8sApiClient k8sApiClient;
        private ExecutorService watchExecutor;
        private final LifecycleLock lifecycleLock = new LifecycleLock();
        private static final Closeable STOP_MARKER = () -> {};
        private final NodeRole nodeRole;
        private final BaseNodeRoleWatcher baseNodeRoleWatcher;
        private final long watcherErrorRetryWaitMS;

        NodeRoleWatcher(ScheduledExecutorService listenerExecutor, NodeRole nodeRole, PodInfo podInfo, K8sDiscoveryConfig discoveryConfig, K8sApiClient k8sApiClient, long watcherErrorRetryWaitMS) {
            this.podInfo = podInfo;
            this.discoveryConfig = discoveryConfig;
            this.k8sApiClient = k8sApiClient;
            this.nodeRole = nodeRole;
            this.baseNodeRoleWatcher = BaseNodeRoleWatcher.create((ScheduledExecutorService)listenerExecutor, (NodeRole)nodeRole);
            this.watcherErrorRetryWaitMS = watcherErrorRetryWaitMS;
        }

        private void watch() {
            String labelSelector = K8sDruidNodeAnnouncer.getLabelSelectorForNodeRole(this.discoveryConfig, this.nodeRole);
            boolean cacheInitialized = false;
            if (!this.lifecycleLock.awaitStarted()) {
                LOGGER.error("Lifecycle not started, Exited Watch for role[%s].", new Object[]{this.nodeRole});
                return;
            }
            while (this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS)) {
                try {
                    DiscoveryDruidNodeList list = this.k8sApiClient.listPods(this.podInfo.getPodNamespace(), labelSelector, this.nodeRole);
                    this.baseNodeRoleWatcher.resetNodes(list.getDruidNodes());
                    if (!cacheInitialized) {
                        this.baseNodeRoleWatcher.cacheInitialized();
                        cacheInitialized = true;
                    }
                    this.keepWatching(labelSelector, list.getResourceVersion());
                }
                catch (Throwable ex) {
                    LOGGER.error(ex, "Exception while watching for role[%s].", new Object[]{this.nodeRole});
                    this.sleep(this.watcherErrorRetryWaitMS);
                }
            }
            LOGGER.info("Exited Watch for role[%s].", new Object[]{this.nodeRole});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void keepWatching(String labelSelector, String resourceVersion) {
            String nextResourceVersion = resourceVersion;
            while (this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS)) {
                try {
                    WatchResult iter = this.k8sApiClient.watchPods(this.podInfo.getPodNamespace(), labelSelector, nextResourceVersion, this.nodeRole);
                    if (iter == null) {
                        return;
                    }
                    try {
                        while (iter.hasNext()) {
                            Watch.Response<DiscoveryDruidNodeAndResourceVersion> item = iter.next();
                            if (item != null && item.type != null && item.object != null) {
                                switch (item.type) {
                                    case "ADDED": {
                                        this.baseNodeRoleWatcher.childAdded(((DiscoveryDruidNodeAndResourceVersion)item.object).getNode());
                                        break;
                                    }
                                    case "DELETED": {
                                        this.baseNodeRoleWatcher.childRemoved(((DiscoveryDruidNodeAndResourceVersion)item.object).getNode());
                                        break;
                                    }
                                }
                            } else {
                                LOGGER.debug("Received NULL item while watching role[%s]. Restarting watch.", new Object[]{this.nodeRole});
                                return;
                            }
                            nextResourceVersion = ((DiscoveryDruidNodeAndResourceVersion)item.object).getResourceVersion();
                        }
                    }
                    finally {
                        iter.close();
                    }
                }
                catch (SocketTimeoutException ex) {
                    this.sleep(this.watcherErrorRetryWaitMS);
                }
                catch (Throwable ex) {
                    LOGGER.error(ex, "Error while watching role[%s]", new Object[]{this.nodeRole});
                    this.sleep(this.watcherErrorRetryWaitMS);
                }
            }
        }

        private void sleep(long ms) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        public void start() {
            if (!this.lifecycleLock.canStart()) {
                throw new ISE("can't start.", new Object[0]);
            }
            try {
                LOGGER.info("Starting NodeRoleWatcher for role[%s]...", new Object[]{this.nodeRole});
                this.watchExecutor = Execs.singleThreaded((String)(this.getClass().getName() + this.nodeRole.getJsonName()));
                this.watchExecutor.submit(this::watch);
                this.lifecycleLock.started();
                LOGGER.info("Started NodeRoleWatcher for role[%s].", new Object[]{this.nodeRole});
            }
            finally {
                this.lifecycleLock.exitStart();
            }
        }

        public void stop() {
            if (!this.lifecycleLock.canStop()) {
                throw new ISE("can't stop.", new Object[0]);
            }
            try {
                LOGGER.info("Stopping NodeRoleWatcher for role[%s]...", new Object[]{this.nodeRole});
                CloseableUtils.closeAndSuppressExceptions((Closeable)STOP_MARKER, e -> {});
                this.watchExecutor.shutdownNow();
                if (!this.watchExecutor.awaitTermination(15L, TimeUnit.SECONDS)) {
                    LOGGER.warn("Failed to stop watchExecutor for role[%s]", new Object[]{this.nodeRole});
                }
                LOGGER.info("Stopped NodeRoleWatcher for role[%s].", new Object[]{this.nodeRole});
            }
            catch (Exception ex) {
                LOGGER.error((Throwable)ex, "Failed to stop NodeRoleWatcher for role[%s].", new Object[]{this.nodeRole});
            }
        }

        public Collection<DiscoveryDruidNode> getAllNodes() {
            return this.baseNodeRoleWatcher.getAllNodes();
        }

        public void registerListener(DruidNodeDiscovery.Listener listener) {
            this.baseNodeRoleWatcher.registerListener(listener);
        }
    }
}

