/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class SchemaRegistryClientConfig {
    public static final String CLIENT_NAMESPACE = "schema.registry.";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE = "basic.auth.credentials.source";
    @Deprecated
    public static final String SCHEMA_REGISTRY_USER_INFO_CONFIG = "schema.registry.basic.auth.user.info";
    public static final String USER_INFO_CONFIG = "basic.auth.user.info";
    public static final String HTTP_CONNECT_TIMEOUT_MS = "http.connect.timeout.ms";
    public static final int HTTP_CONNECT_TIMEOUT_MS_DEFAULT = 60000;
    public static final String HTTP_READ_TIMEOUT_MS = "http.read.timeout.ms";
    public static final int HTTP_READ_TIMEOUT_MS_DEFAULT = 60000;
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE = "bearer.auth.credentials.source";
    public static final String BEARER_AUTH_TOKEN_CONFIG = "bearer.auth.token";
    public static final String PROXY_HOST = "proxy.host";
    public static final String PROXY_PORT = "proxy.port";

    public static void withClientSslSupport(ConfigDef configDef, String namespace) {
        ConfigDef sslConfigDef = new ConfigDef();
        sslConfigDef.withClientSslSupport();
        for (ConfigDef.ConfigKey configKey : sslConfigDef.configKeys().values()) {
            configDef.define(namespace + configKey.name, SchemaRegistryClientConfig.typeFor(configKey.type), configKey.defaultValue, SchemaRegistryClientConfig.importanceFor(configKey.importance), configKey.documentation);
        }
    }

    private static ConfigDef.Type typeFor(ConfigDef.Type type) {
        return ConfigDef.Type.valueOf(type.name());
    }

    private static ConfigDef.Importance importanceFor(ConfigDef.Importance importance) {
        return ConfigDef.Importance.valueOf(importance.name());
    }

    public static Integer getHttpConnectTimeoutMs(Map<String, ?> configs) {
        if (configs != null && configs.containsKey(HTTP_CONNECT_TIMEOUT_MS)) {
            Object httpConnectTimeoutMsVal = configs.get(HTTP_CONNECT_TIMEOUT_MS);
            return httpConnectTimeoutMsVal instanceof String ? Integer.valueOf((String)httpConnectTimeoutMsVal) : (Integer)httpConnectTimeoutMsVal;
        }
        return 60000;
    }

    public static Integer getHttpReadTimeoutMs(Map<String, ?> configs) {
        if (configs != null && configs.containsKey(HTTP_READ_TIMEOUT_MS)) {
            Object httpReadTimeoutMsVal = configs.get(HTTP_READ_TIMEOUT_MS);
            return httpReadTimeoutMsVal instanceof String ? Integer.valueOf((String)httpReadTimeoutMsVal) : (Integer)httpReadTimeoutMsVal;
        }
        return 60000;
    }
}

