/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.protobuf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.os72.protobuf.dynamic.DynamicSchema;
import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.apache.druid.data.input.protobuf.DescriptorBasedProtobufBytesDecoder;
import org.apache.druid.java.util.common.parsers.ParseException;

public class FileBasedProtobufBytesDecoder
extends DescriptorBasedProtobufBytesDecoder {
    private final String descriptorFilePath;

    @JsonCreator
    public FileBasedProtobufBytesDecoder(@JsonProperty(value="descriptor") String descriptorFilePath, @JsonProperty(value="protoMessageType") String protoMessageType) {
        super(protoMessageType);
        Preconditions.checkNotNull((Object)descriptorFilePath);
        this.descriptorFilePath = descriptorFilePath;
        this.initDescriptor();
    }

    @JsonProperty(value="descriptor")
    public String getDescriptorFilePath() {
        return this.descriptorFilePath;
    }

    @Override
    protected DynamicSchema generateDynamicSchema() {
        InputStream fin = this.getClass().getClassLoader().getResourceAsStream(this.descriptorFilePath);
        if (fin == null) {
            URL url;
            try {
                url = new URL(this.descriptorFilePath);
            }
            catch (MalformedURLException e) {
                throw new ParseException(this.descriptorFilePath, (Throwable)e, "Descriptor not found in class path or malformed URL:" + this.descriptorFilePath, new Object[0]);
            }
            try {
                fin = url.openConnection().getInputStream();
            }
            catch (IOException e) {
                throw new ParseException(url.toString(), (Throwable)e, "Cannot read descriptor file: " + url, new Object[0]);
            }
        }
        try {
            return DynamicSchema.parseFrom(fin);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new ParseException(null, (Throwable)e, "Invalid descriptor file: " + this.descriptorFilePath, new Object[0]);
        }
        catch (IOException e) {
            throw new ParseException(null, (Throwable)e, "Cannot read descriptor file: " + this.descriptorFilePath, new Object[0]);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileBasedProtobufBytesDecoder that = (FileBasedProtobufBytesDecoder)o;
        return Objects.equals(this.descriptorFilePath, that.descriptorFilePath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.descriptorFilePath);
    }
}

