/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.msq.dart.controller.DartControllerContext;
import org.apache.druid.msq.dart.worker.DartWorkerClient;
import org.apache.druid.msq.dart.worker.WorkerId;
import org.apache.druid.msq.exec.Controller;
import org.apache.druid.msq.exec.ControllerContext;
import org.apache.druid.msq.exec.QueryListener;
import org.apache.druid.msq.indexing.error.MSQErrorReport;
import org.apache.druid.msq.indexing.error.WorkerFailedFault;
import org.apache.druid.server.security.AuthenticationResult;
import org.joda.time.DateTime;

public class ControllerHolder {
    private final Controller controller;
    private final ControllerContext controllerContext;
    private final String sqlQueryId;
    private final String sql;
    private final String controllerHost;
    private final AuthenticationResult authenticationResult;
    private final DateTime startTime;
    private final AtomicReference<State> state = new AtomicReference<State>(State.ACCEPTED);

    public ControllerHolder(Controller controller, ControllerContext controllerContext, String sqlQueryId, String sql, String controllerHost, AuthenticationResult authenticationResult, DateTime startTime) {
        this.controller = (Controller)Preconditions.checkNotNull((Object)controller, (Object)"controller");
        this.controllerContext = controllerContext;
        this.sqlQueryId = (String)Preconditions.checkNotNull((Object)sqlQueryId, (Object)"sqlQueryId");
        this.sql = sql;
        this.controllerHost = controllerHost;
        this.authenticationResult = authenticationResult;
        this.startTime = (DateTime)Preconditions.checkNotNull((Object)startTime, (Object)"startTime");
    }

    public Controller getController() {
        return this.controller;
    }

    public String getSqlQueryId() {
        return this.sqlQueryId;
    }

    public String getSql() {
        return this.sql;
    }

    public String getControllerHost() {
        return this.controllerHost;
    }

    public AuthenticationResult getAuthenticationResult() {
        return this.authenticationResult;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public State getState() {
        return this.state.get();
    }

    public void workerOffline(WorkerId workerId) {
        String workerIdString = workerId.toString();
        if (this.controllerContext instanceof DartControllerContext) {
            ((DartWorkerClient)this.controllerContext.newWorkerClient()).closeClient(workerId.getHostAndPort());
        }
        if (this.controller.hasWorker(workerIdString)) {
            this.controller.workerError(MSQErrorReport.fromFault(workerIdString, workerId.getHostAndPort(), null, new WorkerFailedFault(workerIdString, "Worker went offline")));
        }
    }

    public void cancel() {
        if (this.state.getAndSet(State.CANCELED) == State.RUNNING) {
            this.controller.stop();
        }
    }

    public boolean run(QueryListener listener) throws Exception {
        if (this.state.compareAndSet(State.ACCEPTED, State.RUNNING)) {
            this.controller.run(listener);
            return true;
        }
        return false;
    }

    public static enum State {
        ACCEPTED,
        RUNNING,
        CANCELED;

    }
}

