/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.collections.QueueNonBlockingPool;
import org.apache.druid.frame.processor.Bouncer;

public class ProcessingBuffers {
    private final NonBlockingPool<ByteBuffer> bufferPool;
    private final Bouncer bouncer;

    public ProcessingBuffers(NonBlockingPool<ByteBuffer> bufferPool, Bouncer bouncer) {
        this.bufferPool = bufferPool;
        this.bouncer = bouncer;
    }

    public static ProcessingBuffers fromCollection(Collection<ByteBuffer> bufferPool) {
        ArrayBlockingQueue<ByteBuffer> queue = new ArrayBlockingQueue<ByteBuffer>(bufferPool.size());
        queue.addAll(bufferPool);
        return new ProcessingBuffers((NonBlockingPool<ByteBuffer>)new QueueNonBlockingPool(queue), new Bouncer(queue.size()));
    }

    public NonBlockingPool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    public Bouncer getBouncer() {
        return this.bouncer;
    }
}

