/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.SettableFuture;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.frame.processor.FrameProcessorExecutor;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.util.DurableStorageUtils;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.counters.CounterSnapshotsTree;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.exec.ControllerClient;
import org.apache.druid.msq.exec.ExceptionWrappingWorkerClient;
import org.apache.druid.msq.exec.MSQTasks;
import org.apache.druid.msq.exec.OutputChannelMode;
import org.apache.druid.msq.exec.RunWorkOrder;
import org.apache.druid.msq.exec.RunWorkOrderListener;
import org.apache.druid.msq.exec.Worker;
import org.apache.druid.msq.exec.WorkerClient;
import org.apache.druid.msq.exec.WorkerContext;
import org.apache.druid.msq.indexing.InputChannelFactory;
import org.apache.druid.msq.indexing.MSQWorkerTask;
import org.apache.druid.msq.indexing.error.CanceledFault;
import org.apache.druid.msq.indexing.error.MSQErrorReport;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.MSQWarningReportLimiterPublisher;
import org.apache.druid.msq.indexing.error.MSQWarningReportSimplePublisher;
import org.apache.druid.msq.input.InputSlices;
import org.apache.druid.msq.input.stage.ReadablePartition;
import org.apache.druid.msq.kernel.FrameContext;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.kernel.controller.ControllerQueryKernelUtils;
import org.apache.druid.msq.kernel.worker.WorkerStageKernel;
import org.apache.druid.msq.kernel.worker.WorkerStagePhase;
import org.apache.druid.msq.shuffle.input.DurableStorageInputChannelFactory;
import org.apache.druid.msq.shuffle.input.MetaInputChannelFactory;
import org.apache.druid.msq.shuffle.input.WorkerInputChannelFactory;
import org.apache.druid.msq.shuffle.input.WorkerOrLocalInputChannelFactory;
import org.apache.druid.msq.shuffle.output.StageOutputHolder;
import org.apache.druid.msq.statistics.ClusterByStatisticsSnapshot;
import org.apache.druid.msq.statistics.PartialKeyStatisticsInformation;
import org.apache.druid.msq.util.DecoratedExecutorService;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.PrioritizedCallable;
import org.apache.druid.query.PrioritizedRunnable;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.server.DruidNode;
import org.apache.druid.utils.CloseableUtils;

public class WorkerImpl
implements Worker {
    private static final Logger log = new Logger(WorkerImpl.class);
    @Nullable
    private final MSQWorkerTask task;
    private final WorkerContext context;
    private final DruidNode selfDruidNode;
    private final BlockingQueue<Consumer<KernelHolders>> kernelManipulationQueue = new LinkedBlockingDeque<Consumer<KernelHolders>>();
    private final ConcurrentHashMap<StageId, ConcurrentHashMap<Integer, StageOutputHolder>> stageOutputs = new ConcurrentHashMap();
    private final ConcurrentHashMap<IntObjectPair<StageId>, CounterTracker> stageCounters = new ConcurrentHashMap();
    private final AtomicBoolean didRun = new AtomicBoolean();
    private final SettableFuture<Void> runFuture = SettableFuture.create();
    private volatile ControllerClient controllerClient;
    private volatile WorkerClient workerClient;
    private volatile boolean controllerAlive = true;

    public WorkerImpl(@Nullable MSQWorkerTask task, WorkerContext context) {
        this.task = task;
        this.context = context;
        this.selfDruidNode = context.selfNode();
    }

    @Override
    public String id() {
        return this.context.workerId();
    }

    @Override
    public void run() {
        if (!this.didRun.compareAndSet(false, true)) {
            throw new ISE("already run", new Object[0]);
        }
        try (Closer closer = Closer.create();){
            Optional<MSQErrorReport> maybeErrorReport;
            KernelHolders kernelHolders = KernelHolders.create(this.context, closer);
            this.controllerClient = kernelHolders.getControllerClient();
            Throwable t = null;
            try {
                maybeErrorReport = this.runInternal(kernelHolders, closer);
            }
            catch (Throwable e) {
                t = e;
                maybeErrorReport = Optional.of(MSQErrorReport.fromException(this.context.workerId(), MSQTasks.getHostFromSelfNode(this.context.selfNode()), null, e));
            }
            if (maybeErrorReport.isPresent()) {
                MSQErrorReport errorReport = maybeErrorReport.get();
                String logMessage = MSQTasks.errorReportToLogMessage(errorReport);
                log.warn("%s", new Object[]{logMessage});
                if (this.controllerAlive) {
                    this.controllerClient.postWorkerError(errorReport);
                }
                if (t != null) {
                    Throwables.throwIfInstanceOf((Throwable)t, MSQException.class);
                    throw new MSQException(t, maybeErrorReport.get().getFault());
                }
                throw new MSQException(maybeErrorReport.get().getFault());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.runFuture.set(null);
        }
    }

    private Optional<MSQErrorReport> runInternal(KernelHolders kernelHolders, Closer workerCloser) throws Exception {
        this.context.registerWorker(this, workerCloser);
        workerCloser.register((Closeable)this.context.dataServerQueryHandlerFactory());
        this.workerClient = (WorkerClient)workerCloser.register((Closeable)new ExceptionWrappingWorkerClient(this.context.makeWorkerClient()));
        FrameProcessorExecutor workerExec = new FrameProcessorExecutor(this.makeProcessingPool());
        long maxAllowedParseExceptions = this.task != null ? Long.parseLong(((Object)this.task.getContext().getOrDefault("maxParseExceptions", Long.MAX_VALUE)).toString()) : 0L;
        long maxVerboseParseExceptions = maxAllowedParseExceptions == -1L ? 5L : Math.min(maxAllowedParseExceptions, 5L);
        ImmutableSet criticalWarningCodes = maxAllowedParseExceptions == 0L ? ImmutableSet.of((Object)"CannotParseExternalData") : ImmutableSet.of();
        HashSet<StageId> kernelsToRemove = new HashSet<StageId>();
        while (!kernelHolders.isDone()) {
            Consumer nextCommand;
            boolean didSomething = false;
            for (KernelHolder kernelHolder : kernelHolders.getAllKernelHolders()) {
                WorkerStageKernel kernel = kernelHolder.kernel;
                StageDefinition stageDefinition = kernel.getStageDefinition();
                if (kernel.getPhase() == WorkerStagePhase.NEW && kernelHolders.runningKernelCount() < this.context.maxConcurrentStages()) {
                    this.handleNewWorkOrder(kernelHolder, this.controllerClient, workerExec, (Set<String>)criticalWarningCodes, maxVerboseParseExceptions);
                    WorkerImpl.logKernelStatus(kernelHolders.getAllKernels());
                    didSomething = true;
                }
                if (kernel.getPhase() == WorkerStagePhase.READING_INPUT && this.handleReadingInput(kernelHolder, this.controllerClient)) {
                    didSomething = true;
                    WorkerImpl.logKernelStatus(kernelHolders.getAllKernels());
                }
                if (kernel.getPhase() == WorkerStagePhase.PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES && this.handleWaitingForResultPartitionBoundaries(kernelHolder)) {
                    didSomething = true;
                    WorkerImpl.logKernelStatus(kernelHolders.getAllKernels());
                }
                if (kernel.getPhase() == WorkerStagePhase.RESULTS_COMPLETE && this.handleResultsReady(kernelHolder, this.controllerClient)) {
                    didSomething = true;
                    WorkerImpl.logKernelStatus(kernelHolders.getAllKernels());
                }
                if (kernel.getPhase() == WorkerStagePhase.FAILED) {
                    return Optional.of(MSQErrorReport.fromException(this.id(), MSQTasks.getHostFromSelfNode(this.selfDruidNode), stageDefinition.getId().getStageNumber(), kernel.getException()));
                }
                if (!kernel.getPhase().isTerminal()) continue;
                this.handleTerminated(kernelHolder);
                kernelsToRemove.add(stageDefinition.getId());
            }
            for (StageId stageId : kernelsToRemove) {
                kernelHolders.removeKernel(stageId);
            }
            kernelsToRemove.clear();
            if (didSomething || kernelHolders.isDone()) continue;
            do {
                this.postCountersToController(kernelHolders.getControllerClient());
            } while ((nextCommand = this.kernelManipulationQueue.poll(5L, TimeUnit.SECONDS)) == null);
            nextCommand.accept((KernelHolders)kernelHolders);
            while ((nextCommand = (Consumer)this.kernelManipulationQueue.poll()) != null) {
                nextCommand.accept(kernelHolders);
            }
            WorkerImpl.logKernelStatus(kernelHolders.getAllKernels());
        }
        return Optional.empty();
    }

    private void handleNewWorkOrder(KernelHolder kernelHolder, ControllerClient controllerClient, FrameProcessorExecutor workerExec, Set<String> criticalWarningCodes, long maxVerboseParseExceptions) throws IOException {
        WorkerStageKernel kernel = kernelHolder.kernel;
        WorkOrder workOrder = kernel.getWorkOrder();
        StageDefinition stageDefinition = workOrder.getStageDefinition();
        String cancellationId = WorkerImpl.cancellationIdFor(stageDefinition.getId(), workOrder.getWorkerNumber());
        log.info("Starting work order for stage[%s], workerNumber[%d]%s", new Object[]{stageDefinition.getId(), workOrder.getWorkerNumber(), log.isDebugEnabled() ? StringUtils.format((String)", payload[%s]", (Object[])new Object[]{this.context.jsonMapper().writeValueAsString((Object)workOrder)}) : ""});
        FrameContext frameContext = this.context.frameContext(workOrder);
        kernelHolder.resultsCloser.register(() -> FileUtils.deleteDirectory((File)frameContext.tempDir()));
        kernelHolder.resultsCloser.register(() -> this.removeStageOutputChannels(stageDefinition.getId()));
        InputChannelFactory inputChannelFactory = this.makeBaseInputChannelFactory(workOrder, controllerClient, kernelHolder.processorCloser);
        boolean includeAllCounters = this.context.includeAllCounters();
        RunWorkOrder runWorkOrder = new RunWorkOrder(workOrder, inputChannelFactory, this.stageCounters.computeIfAbsent((IntObjectPair<StageId>)IntObjectPair.of((int)workOrder.getWorkerNumber(), (Object)stageDefinition.getId()), ignored -> new CounterTracker(includeAllCounters)), workerExec, cancellationId, this.context, frameContext, this.makeRunWorkOrderListener(workOrder, controllerClient, criticalWarningCodes, maxVerboseParseExceptions), MultiStageQueryContext.isReindex(workOrder.getWorkerContext()), MultiStageQueryContext.removeNullBytes(workOrder.getWorkerContext()));
        kernelHolder.processorCloser.register(() -> runWorkOrder.stopUnchecked(null));
        kernel.startReading();
        runWorkOrder.startAsync();
        kernelHolder.partitionBoundariesFuture = runWorkOrder.getStagePartitionBoundariesFuture();
    }

    private boolean handleReadingInput(KernelHolder kernelHolder, ControllerClient controllerClient) throws IOException {
        WorkerStageKernel kernel = kernelHolder.kernel;
        if (kernel.hasResultKeyStatisticsSnapshot()) {
            if (this.controllerAlive) {
                PartialKeyStatisticsInformation partialKeyStatisticsInformation = kernel.getResultKeyStatisticsSnapshot().partialKeyStatistics();
                controllerClient.postPartialKeyStatistics(kernel.getStageDefinition().getId(), kernel.getWorkOrder().getWorkerNumber(), partialKeyStatisticsInformation);
            }
            kernel.startPreshuffleWaitingForResultPartitionBoundaries();
            return true;
        }
        if (kernel.isDoneReadingInput() && kernel.getStageDefinition().doesSortDuringShuffle() && !kernel.getStageDefinition().mustGatherResultKeyStatistics()) {
            if (this.controllerAlive && this.context.maxConcurrentStages() > 1) {
                controllerClient.postDoneReadingInput(kernel.getStageDefinition().getId(), kernel.getWorkOrder().getWorkerNumber());
            }
            kernel.startPreshuffleWritingOutput();
            return true;
        }
        return false;
    }

    private boolean handleWaitingForResultPartitionBoundaries(KernelHolder kernelHolder) {
        if (kernelHolder.kernel.hasResultPartitionBoundaries()) {
            kernelHolder.partitionBoundariesFuture.set((Object)kernelHolder.kernel.getResultPartitionBoundaries());
            kernelHolder.kernel.startPreshuffleWritingOutput();
            return true;
        }
        return false;
    }

    private boolean handleResultsReady(KernelHolder kernelHolder, ControllerClient controllerClient) throws IOException {
        WorkerStageKernel kernel = kernelHolder.kernel;
        boolean didNotPostYet = kernel.addPostedResultsComplete(kernel.getStageDefinition().getId(), kernel.getWorkOrder().getWorkerNumber());
        if (this.controllerAlive && didNotPostYet) {
            controllerClient.postResultsComplete(kernel.getStageDefinition().getId(), kernel.getWorkOrder().getWorkerNumber(), kernel.getResultObject());
        }
        return didNotPostYet;
    }

    private void handleTerminated(KernelHolder kernelHolder) {
        WorkerStageKernel kernel = kernelHolder.kernel;
        this.removeStageOutputChannels(kernel.getStageDefinition().getId());
        if (kernelHolder.kernel.getWorkOrder().getOutputChannelMode().isDurable()) {
            this.removeStageDurableStorageOutput(kernel.getStageDefinition().getId());
        }
    }

    @Override
    public void stop() {
        log.info("Worker id[%s] canceled.", new Object[]{this.context.workerId()});
        if (this.didRun.compareAndSet(false, true)) {
            this.runFuture.set(null);
        } else {
            this.doCancel();
        }
    }

    @Override
    public void awaitStop() {
        FutureUtils.getUnchecked(this.runFuture, (boolean)false);
    }

    @Override
    public void controllerFailed() {
        log.info("Controller task[%s] for worker[%s] failed. Canceling.", new Object[]{this.task != null ? this.task.getControllerTaskId() : null, this.id()});
        this.doCancel();
    }

    @Override
    public ListenableFuture<InputStream> readStageOutput(StageId stageId, int partitionNumber, long offset) {
        return this.getOrCreateStageOutputHolder(stageId, partitionNumber).readRemotelyFrom(offset);
    }

    @Override
    public void postWorkOrder(WorkOrder workOrder) {
        log.info("Got work order for stage[%s], workerNumber[%s]", new Object[]{workOrder.getStageDefinition().getId(), workOrder.getWorkerNumber()});
        if (this.task != null && this.task.getWorkerNumber() != workOrder.getWorkerNumber()) {
            throw new ISE("Worker number mismatch: expected workerNumber[%d], got[%d]", new Object[]{this.task.getWorkerNumber(), workOrder.getWorkerNumber()});
        }
        WorkOrder workOrderToUse = WorkerImpl.makeWorkOrderToUse(workOrder, this.task != null && this.task.getContext() != null ? QueryContext.of((Map)this.task.getContext()) : QueryContext.empty());
        this.kernelManipulationQueue.add(kernelHolders -> kernelHolders.addKernel(WorkerStageKernel.create(workOrderToUse)));
    }

    @Override
    public boolean postResultPartitionBoundaries(StageId stageId, ClusterByPartitions stagePartitionBoundaries) {
        this.kernelManipulationQueue.add(kernelHolders -> {
            WorkerStageKernel stageKernel = kernelHolders.getKernelFor(stageId);
            if (stageKernel != null) {
                if (!stageKernel.hasResultPartitionBoundaries()) {
                    stageKernel.setResultPartitionBoundaries(stagePartitionBoundaries);
                } else {
                    log.warn("Stage[%s] already has result partition boundaries set. Ignoring new ones.", new Object[]{stageId});
                }
            }
        });
        return true;
    }

    @Override
    public void postCleanupStage(StageId stageId) {
        log.debug("Received cleanup order for stage[%s].", new Object[]{stageId});
        this.kernelManipulationQueue.add(holder -> {
            holder.finishProcessing(stageId);
            WorkerStageKernel kernel = holder.getKernelFor(stageId);
            if (kernel != null) {
                kernel.setStageFinished();
            }
        });
    }

    @Override
    public void postFinish() {
        log.debug("Received finish call.", new Object[0]);
        this.kernelManipulationQueue.add(KernelHolders::setDone);
    }

    @Override
    public ClusterByStatisticsSnapshot fetchStatisticsSnapshot(StageId stageId) {
        log.debug("Fetching statistics for stage[%s]", new Object[]{stageId});
        SettableFuture snapshotFuture = SettableFuture.create();
        this.kernelManipulationQueue.add(holder -> {
            try {
                WorkerStageKernel kernel = holder.getKernelFor(stageId);
                if (kernel != null) {
                    ClusterByStatisticsSnapshot snapshot = kernel.getResultKeyStatisticsSnapshot();
                    if (snapshot == null) {
                        throw new ISE("Requested statistics snapshot is not generated yet for stage [%s]", new Object[]{stageId});
                    }
                    snapshotFuture.set((Object)snapshot);
                } else {
                    snapshotFuture.setException((Throwable)new ISE("Stage[%s] has terminated", new Object[]{stageId}));
                }
            }
            catch (Throwable t) {
                snapshotFuture.setException(t);
            }
        });
        return (ClusterByStatisticsSnapshot)FutureUtils.getUnchecked((ListenableFuture)snapshotFuture, (boolean)true);
    }

    @Override
    public ClusterByStatisticsSnapshot fetchStatisticsSnapshotForTimeChunk(StageId stageId, long timeChunk) {
        return this.fetchStatisticsSnapshot(stageId).getSnapshotForTimeChunk(timeChunk);
    }

    @Override
    public CounterSnapshotsTree getCounters() {
        CounterSnapshotsTree retVal = new CounterSnapshotsTree();
        for (Map.Entry<IntObjectPair<StageId>, CounterTracker> entry : this.stageCounters.entrySet()) {
            retVal.put(((StageId)entry.getKey().right()).getStageNumber(), entry.getKey().leftInt(), entry.getValue().snapshot());
        }
        return retVal;
    }

    private RunWorkOrderListener makeRunWorkOrderListener(WorkOrder workOrder, ControllerClient controllerClient, Set<String> criticalWarningCodes, long maxVerboseParseExceptions) {
        final StageId stageId = workOrder.getStageDefinition().getId();
        final MSQWarningReportLimiterPublisher msqWarningReportPublisher = new MSQWarningReportLimiterPublisher(new MSQWarningReportSimplePublisher(this.id(), controllerClient, this.id(), MSQTasks.getHostFromSelfNode(this.selfDruidNode)), 10L, (Map<String, Long>)ImmutableMap.of((Object)"CannotParseExternalData", (Object)maxVerboseParseExceptions), criticalWarningCodes, controllerClient, this.id(), MSQTasks.getHostFromSelfNode(this.selfDruidNode));
        return new RunWorkOrderListener(){

            @Override
            public void onDoneReadingInput(@Nullable ClusterByStatisticsSnapshot snapshot) {
                WorkerImpl.this.kernelManipulationQueue.add(holder -> {
                    WorkerStageKernel kernel = holder.getKernelFor(stageId);
                    if (kernel != null) {
                        kernel.setResultKeyStatisticsSnapshot(snapshot);
                    }
                });
            }

            @Override
            public void onOutputChannelAvailable(OutputChannel channel) {
                ReadableFrameChannel readableChannel = null;
                try {
                    readableChannel = channel.getReadableChannel();
                    WorkerImpl.this.getOrCreateStageOutputHolder(stageId, channel.getPartitionNumber()).setChannel(readableChannel);
                }
                catch (Exception e) {
                    if (readableChannel != null) {
                        try {
                            readableChannel.close();
                        }
                        catch (Throwable e2) {
                            e.addSuppressed(e2);
                        }
                    }
                    WorkerImpl.this.kernelManipulationQueue.add(holder -> {
                        throw new RE((Throwable)e, "Worker completion callback error for stage [%s]", new Object[]{stageId});
                    });
                }
            }

            @Override
            public void onSuccess(Object resultObject) {
                WorkerImpl.this.kernelManipulationQueue.add(holder -> {
                    holder.finishProcessing(stageId);
                    WorkerStageKernel kernel = holder.getKernelFor(stageId);
                    if (kernel != null) {
                        kernel.setResultsComplete(resultObject);
                    }
                });
            }

            @Override
            public void onWarning(Throwable t) {
                msqWarningReportPublisher.publishException(stageId.getStageNumber(), t);
            }

            @Override
            public void onFailure(Throwable t) {
                WorkerImpl.this.kernelManipulationQueue.add(holder -> {
                    WorkerStageKernel kernel = holder.getKernelFor(stageId);
                    if (kernel != null) {
                        kernel.fail(t);
                    }
                });
            }
        };
    }

    private InputChannelFactory makeBaseInputChannelFactory(WorkOrder workOrder, ControllerClient controllerClient, Closer closer) {
        return MetaInputChannelFactory.create(InputSlices.allStageSlices(workOrder.getInputs()), workOrder.getOutputChannelMode(), outputChannelMode -> {
            switch (outputChannelMode) {
                case MEMORY: 
                case LOCAL_STORAGE: {
                    Object workerIds = workOrder.getWorkerIds() != null ? workOrder::getWorkerIds : Suppliers.memoize(() -> {
                        try {
                            return controllerClient.getWorkerIds();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    return new WorkerOrLocalInputChannelFactory(this.id(), (Supplier<List<String>>)workerIds, new WorkerInputChannelFactory(this.workerClient, (Supplier<List<String>>)workerIds), this::getOrCreateStageOutputHolder);
                }
                case DURABLE_STORAGE_INTERMEDIATE: 
                case DURABLE_STORAGE_QUERY_RESULTS: {
                    return DurableStorageInputChannelFactory.createStandardImplementation(this.task.getControllerTaskId(), MSQTasks.makeStorageConnector(this.context.injector()), closer, outputChannelMode == OutputChannelMode.DURABLE_STORAGE_QUERY_RESULTS);
                }
            }
            throw DruidException.defensive((String)"No handling for output channel mode[%s]", (Object[])new Object[]{outputChannelMode});
        });
    }

    private ListeningExecutorService makeProcessingPool() {
        QueryProcessingPool queryProcessingPool = (QueryProcessingPool)this.context.injector().getInstance(QueryProcessingPool.class);
        boolean priority = false;
        return new DecoratedExecutorService((ListeningExecutorService)queryProcessingPool, new DecoratedExecutorService.Decorator(){

            @Override
            public <T> Callable<T> decorateCallable(final Callable<T> callable) {
                return new PrioritizedCallable<T>(){

                    public int getPriority() {
                        return 0;
                    }

                    public T call() throws Exception {
                        return callable.call();
                    }
                };
            }

            @Override
            public Runnable decorateRunnable(final Runnable runnable) {
                return new PrioritizedRunnable(){

                    public int getPriority() {
                        return 0;
                    }

                    public void run() {
                        runnable.run();
                    }
                };
            }
        });
    }

    private void postCountersToController(ControllerClient controllerClient) throws IOException {
        CounterSnapshotsTree snapshotsTree = this.getCounters();
        if (this.controllerAlive && !snapshotsTree.isEmpty()) {
            controllerClient.postCounters(this.id(), snapshotsTree);
        }
    }

    private void removeStageOutputChannels(StageId stageId) {
        ConcurrentHashMap<Integer, StageOutputHolder> partitionOutputsForStage = this.stageOutputs.remove(stageId);
        if (partitionOutputsForStage == null) {
            return;
        }
        Iterator iterator = ((ConcurrentHashMap.KeySetView)partitionOutputsForStage.keySet()).iterator();
        while (iterator.hasNext()) {
            int partition = (Integer)iterator.next();
            StageOutputHolder output = partitionOutputsForStage.remove(partition);
            if (output == null) continue;
            output.close();
        }
    }

    private void removeStageDurableStorageOutput(StageId stageId) {
        String folderName = DurableStorageUtils.getTaskIdOutputsFolderName((String)this.task.getControllerTaskId(), (int)stageId.getStageNumber(), (int)this.task.getWorkerNumber(), (String)this.context.workerId());
        try {
            MSQTasks.makeStorageConnector(this.context.injector()).deleteRecursively(folderName);
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Error while cleaning up durable storage path[%s].", new Object[]{folderName});
        }
    }

    private StageOutputHolder getOrCreateStageOutputHolder(StageId stageId, int partitionNumber) {
        return this.stageOutputs.computeIfAbsent(stageId, ignored1 -> new ConcurrentHashMap()).computeIfAbsent(partitionNumber, ignored -> new StageOutputHolder());
    }

    private static String cancellationIdFor(StageId stageId, int workerNumber) {
        return StringUtils.format((String)"msq-worker[%s_%s]", (Object[])new Object[]{stageId, workerNumber});
    }

    private void doCancel() {
        this.controllerAlive = false;
        if (this.controllerClient != null) {
            this.controllerClient.close();
        }
        if (this.workerClient != null) {
            CloseableUtils.closeAndSuppressExceptions((Closeable)this.workerClient, e -> log.warn("Failed to close workerClient", new Object[0]));
        }
        this.kernelManipulationQueue.clear();
        this.kernelManipulationQueue.add(kernel -> {
            throw new MSQException(CanceledFault.INSTANCE);
        });
    }

    static WorkOrder makeWorkOrderToUse(WorkOrder originalWorkOrder, @Nullable QueryContext taskContext) {
        QueryContext queryContext = originalWorkOrder.hasWorkerContext() ? originalWorkOrder.getWorkerContext() : (taskContext != null ? taskContext : QueryContext.empty());
        OutputChannelMode outputChannelMode = originalWorkOrder.hasOutputChannelMode() ? originalWorkOrder.getOutputChannelMode() : ControllerQueryKernelUtils.getOutputChannelMode(originalWorkOrder.getQueryDefinition(), originalWorkOrder.getStageNumber(), MultiStageQueryContext.getSelectDestination(queryContext), MultiStageQueryContext.isDurableStorageEnabled(queryContext), false);
        return originalWorkOrder.withWorkerContext(queryContext).withOutputChannelMode(outputChannelMode);
    }

    private static void logKernelStatus(Iterable<WorkerStageKernel> kernels) {
        if (log.isDebugEnabled()) {
            log.debug("Stages: %s", new Object[]{StreamSupport.stream(kernels.spliterator(), false).sorted(Comparator.comparing(k -> k.getStageDefinition().getStageNumber())).map(WorkerImpl::makeKernelStageStatusString).collect(Collectors.joining("; "))});
        }
    }

    private static String makeKernelStageStatusString(WorkerStageKernel kernel) {
        String inputPartitionNumbers = StreamSupport.stream(InputSlices.allReadablePartitions(kernel.getWorkOrder().getInputs()).spliterator(), false).map(ReadablePartition::getPartitionNumber).sorted().map(String::valueOf).collect(Collectors.joining(","));
        String shuffleStatus = kernel.getStageDefinition().doesShuffle() ? ">" + (Serializable)(kernel.hasResultPartitionBoundaries() ? Integer.valueOf(kernel.getResultPartitionBoundaries().size()) : "?") : "";
        return StringUtils.format((String)"S%d:W%d:P[%s]%s:%s:%s", (Object[])new Object[]{kernel.getStageDefinition().getStageNumber(), kernel.getWorkOrder().getWorkerNumber(), inputPartitionNumbers, shuffleStatus, kernel.getStageDefinition().doesShuffle() ? "SHUFFLE" : "RETAIN", kernel.getPhase()});
    }

    private static class KernelHolder {
        private final WorkerStageKernel kernel;
        private SettableFuture<ClusterByPartitions> partitionBoundariesFuture;
        private final Closer processorCloser;
        private final Closer resultsCloser;

        public KernelHolder(WorkerStageKernel kernel) {
            this.kernel = kernel;
            this.processorCloser = Closer.create();
            this.resultsCloser = Closer.create();
        }
    }

    private static class KernelHolders
    implements Closeable {
        private final WorkerContext workerContext;
        private final ControllerClient controllerClient;
        private final Int2ObjectMap<KernelHolder> holderMap = new Int2ObjectOpenHashMap();
        private boolean done = false;

        private KernelHolders(WorkerContext workerContext, ControllerClient controllerClient) {
            this.workerContext = workerContext;
            this.controllerClient = controllerClient;
        }

        public static KernelHolders create(WorkerContext workerContext, Closer closer) {
            return (KernelHolders)closer.register((Closeable)new KernelHolders(workerContext, (ControllerClient)closer.register((Closeable)workerContext.makeControllerClient())));
        }

        public void addKernel(WorkerStageKernel kernel) {
            StageId stageId = kernel.getWorkOrder().getStageDefinition().getId();
            if (this.holderMap.putIfAbsent(stageId.getStageNumber(), (Object)new KernelHolder(kernel)) != null) {
                // empty if block
            }
        }

        public void finishProcessing(StageId stageId) {
            KernelHolder kernel = (KernelHolder)this.holderMap.get(stageId.getStageNumber());
            if (kernel != null) {
                try {
                    kernel.processorCloser.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void removeKernel(StageId stageId) {
            KernelHolder removed = (KernelHolder)this.holderMap.remove(stageId.getStageNumber());
            if (removed == null) {
                throw new ISE("No kernel for stage[%s]", new Object[]{stageId});
            }
            try {
                removed.processorCloser.close();
                removed.resultsCloser.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Iterable<KernelHolder> getAllKernelHolders() {
            return this.holderMap.values();
        }

        public Iterable<WorkerStageKernel> getAllKernels() {
            return Iterables.transform((Iterable)this.holderMap.values(), holder -> holder.kernel);
        }

        public int runningKernelCount() {
            int retVal = 0;
            for (KernelHolder holder : this.holderMap.values()) {
                if (!holder.kernel.getPhase().isRunning()) continue;
                ++retVal;
            }
            return retVal;
        }

        @Nullable
        public WorkerStageKernel getKernelFor(StageId stageId) {
            KernelHolder holder = (KernelHolder)this.holderMap.get(stageId.getStageNumber());
            if (holder != null) {
                return holder.kernel;
            }
            return null;
        }

        public ControllerClient getControllerClient() {
            return this.controllerClient;
        }

        @Override
        public void close() {
            UnmodifiableIterator unmodifiableIterator = ImmutableList.copyOf((Collection)this.holderMap.keySet()).iterator();
            while (unmodifiableIterator.hasNext()) {
                int stageNumber = (Integer)unmodifiableIterator.next();
                StageId stageId = new StageId(this.workerContext.queryId(), stageNumber);
                try {
                    this.removeKernel(stageId);
                }
                catch (Exception e) {
                    log.warn((Throwable)e, "Failed to remove kernel for stage[%s].", new Object[]{stageId});
                }
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public void setDone() {
            this.done = true;
        }
    }
}

