/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.sql;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.QueryContexts;

public enum MSQMode {
    NON_STRICT_MODE("nonStrict", (Map<String, Object>)ImmutableMap.of((Object)"maxParseExceptions", (Object)-1)),
    STRICT_MODE("strict", (Map<String, Object>)ImmutableMap.of((Object)"maxParseExceptions", (Object)0));

    private final String value;
    private final Map<String, Object> defaultQueryContext;
    private static final Logger log;

    private MSQMode(String value, Map<String, Object> defaultQueryContext) {
        this.value = value;
        this.defaultQueryContext = new HashMap<String, Object>(defaultQueryContext);
    }

    @Nullable
    public static MSQMode fromString(String str) {
        for (MSQMode msqMode : MSQMode.values()) {
            if (!msqMode.value.equalsIgnoreCase(str)) continue;
            return msqMode;
        }
        return null;
    }

    public String toString() {
        return this.value;
    }

    public static void populateDefaultQueryContext(String modeStr, Map<String, Object> originalQueryContext) {
        MSQMode mode = MSQMode.fromString(modeStr);
        if (mode == null) {
            throw new ISE("%s is an unknown multi stage query mode. Acceptable modes: %s", new Object[]{modeStr, Arrays.stream(MSQMode.values()).map(m -> m.value).collect(Collectors.toList())});
        }
        log.debug("Populating default query context with %s for the %s multi stage query mode", new Object[]{mode.defaultQueryContext, mode});
        QueryContexts.addDefaults(originalQueryContext, mode.defaultQueryContext);
    }

    static {
        log = new Logger(MSQMode.class);
    }
}

