/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.statistics.KeyCollectorFactory;
import org.apache.druid.msq.statistics.QuantilesSketchKeyCollector;
import org.apache.druid.msq.statistics.QuantilesSketchKeyCollectorSnapshot;
import org.apache.druid.segment.column.RowSignature;

public class QuantilesSketchKeyCollectorFactory
implements KeyCollectorFactory<QuantilesSketchKeyCollector, QuantilesSketchKeyCollectorSnapshot> {
    @VisibleForTesting
    static final int SKETCH_INITIAL_K = 32768;
    private final Comparator<byte[]> comparator;

    private QuantilesSketchKeyCollectorFactory(Comparator<byte[]> comparator) {
        this.comparator = comparator;
    }

    static QuantilesSketchKeyCollectorFactory create(ClusterBy clusterBy, RowSignature rowSignature) {
        return new QuantilesSketchKeyCollectorFactory(clusterBy.byteKeyComparator(rowSignature));
    }

    @Override
    public QuantilesSketchKeyCollector newKeyCollector() {
        return new QuantilesSketchKeyCollector(this.comparator, (ItemsSketch<byte[]>)ItemsSketch.getInstance(byte[].class, (int)32768, this.comparator), 0.0);
    }

    @Override
    public QuantilesSketchKeyCollectorSnapshot toSnapshot(QuantilesSketchKeyCollector collector) {
        String encodedSketch = StringUtils.encodeBase64String((byte[])collector.getSketch().toByteArray((ArrayOfItemsSerDe)ByteRowKeySerde.INSTANCE));
        return new QuantilesSketchKeyCollectorSnapshot(encodedSketch, collector.getAverageKeyLength());
    }

    @Override
    public QuantilesSketchKeyCollector fromSnapshot(QuantilesSketchKeyCollectorSnapshot snapshot) {
        String encodedSketch = snapshot.getEncodedSketch();
        byte[] bytes = StringUtils.decodeBase64String((String)encodedSketch);
        ItemsSketch sketch = ItemsSketch.getInstance(byte[].class, (Memory)Memory.wrap((byte[])bytes), this.comparator, (ArrayOfItemsSerDe)ByteRowKeySerde.INSTANCE);
        return new QuantilesSketchKeyCollector(this.comparator, (ItemsSketch<byte[]>)sketch, snapshot.getAverageKeyLength());
    }

    static class ByteRowKeySerde
    extends ArrayOfItemsSerDe<byte[]> {
        static final ByteRowKeySerde INSTANCE = new ByteRowKeySerde();

        private ByteRowKeySerde() {
        }

        public byte[] serializeToByteArray(byte[][] items) {
            int serializedSize = 4 * items.length;
            for (byte[] key : items) {
                serializedSize += key.length;
            }
            byte[] serializedBytes = new byte[serializedSize];
            WritableMemory writableMemory = WritableMemory.writableWrap((byte[])serializedBytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            long keyWritePosition = 4L * (long)items.length;
            for (int i = 0; i < items.length; ++i) {
                byte[] keyBytes = items[i];
                writableMemory.putInt(4L * (long)i, keyBytes.length);
                writableMemory.putByteArray(keyWritePosition, keyBytes, 0, keyBytes.length);
                keyWritePosition += (long)keyBytes.length;
            }
            assert (keyWritePosition == (long)serializedSize);
            return serializedBytes;
        }

        public byte[][] deserializeFromMemory(Memory mem, long offsetBytes, int numItems) {
            byte[][] keys = new byte[numItems][];
            long start = offsetBytes;
            offsetBytes += 4L * (long)numItems;
            for (int i = 0; i < numItems; ++i) {
                int keyLength = mem.getInt(start + 4L * (long)i);
                byte[] keyBytes = new byte[keyLength];
                mem.getByteArray(offsetBytes, keyBytes, 0, keyLength);
                keys[i] = keyBytes;
                offsetBytes += (long)keyLength;
            }
            return keys;
        }

        public byte[] serializeToByteArray(byte[] item) {
            byte[] bytes = new byte[4 + item.length];
            ByteArrayUtil.putIntLE((byte[])bytes, (int)0, (int)item.length);
            ByteArrayUtil.copyBytes((byte[])item, (int)0, (byte[])bytes, (int)4, (int)item.length);
            return bytes;
        }

        public byte[][] deserializeFromMemory(Memory mem, int numItems) {
            return this.deserializeFromMemory(mem, 0L, numItems);
        }

        public int sizeOf(byte[] item) {
            return 4 + item.length;
        }

        public int sizeOf(Memory mem, long offsetBytes, int numItems) {
            int length = 4 * numItems;
            for (int i = 0; i < numItems; ++i) {
                length += mem.getInt(offsetBytes + 4L * (long)i);
            }
            return length;
        }

        public String toString(byte[] item) {
            return Arrays.toString(item);
        }

        public Class<?> getClassOfT() {
            return byte[].class;
        }
    }
}

