/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics.serde;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.msq.statistics.ClusterByStatisticsSnapshot;
import org.apache.druid.msq.statistics.KeyCollectorSnapshot;
import org.apache.druid.msq.statistics.serde.KeyCollectorSnapshotDeserializer;

public class ClusterByStatisticsSnapshotSerde {
    private static final byte EMPTY_HEADER = 0;
    private static final int HEADER_OFFSET = 0;
    private static final int BUCKET_COUNT_OFFSET = 1;
    private static final int MV_SET_SIZE_OFFSET = 5;
    private static final int MV_VALUES_OFFSET = 9;
    private static final int TIMECHUNK_OFFSET = 0;
    private static final int BUCKET_SIZE_OFFSET = 8;
    private static final int BUCKET_OFFSET = 12;
    private static final int BYTES_RETAINED_OFFSET = 0;
    private static final int KEY_LENGTH_OFFSET = 8;
    private static final int SNAPSHOT_LENGTH_OFFSET = 12;
    private static final int KEY_OFFSET = 16;

    public static void serialize(OutputStream outputStream, @NotNull ClusterByStatisticsSnapshot snapshot) throws IOException {
        Map<Long, ClusterByStatisticsSnapshot.Bucket> buckets = snapshot.getBuckets();
        Set<Integer> multipleValueBuckets = snapshot.getHasMultipleValues();
        outputStream.write(0);
        ClusterByStatisticsSnapshotSerde.writeIntToStream(outputStream, buckets.size());
        ByteBuffer multivalueBuffer = ByteBuffer.allocate(4 + multipleValueBuckets.size()).putInt(multipleValueBuckets.size());
        multipleValueBuckets.forEach(multivalueBuffer::putInt);
        outputStream.write(multivalueBuffer.array());
        for (Map.Entry<Long, ClusterByStatisticsSnapshot.Bucket> entry : buckets.entrySet()) {
            ClusterByStatisticsSnapshotSerde.writeLongToStream(outputStream, entry.getKey());
            ClusterByStatisticsSnapshotSerde.serializeBucket(outputStream, entry.getValue());
        }
    }

    public static ClusterByStatisticsSnapshot deserialize(ByteBuffer byteBuffer) {
        int position = byteBuffer.position();
        int bucketCount = byteBuffer.getInt(position + 1);
        int mvSetSize = byteBuffer.getInt(position + 5);
        HashSet<Integer> hasMultiValues = new HashSet<Integer>();
        for (int offset = position + 9; offset < position + 9 + mvSetSize * 4; offset += 4) {
            hasMultiValues.add(byteBuffer.getInt(offset));
        }
        HashMap<Long, ClusterByStatisticsSnapshot.Bucket> buckets = new HashMap<Long, ClusterByStatisticsSnapshot.Bucket>();
        int nextBucket = position + 9 + 4 * mvSetSize;
        for (int bucketNo = 0; bucketNo < bucketCount; ++bucketNo) {
            position = byteBuffer.position(nextBucket).position();
            long timeChunk = byteBuffer.getLong(position + 0);
            int snapshotSize = byteBuffer.getInt(position + 8);
            ByteBuffer duplicate = byteBuffer.duplicate().order(byteBuffer.order()).position(position + 12).limit(position + 12 + snapshotSize);
            ClusterByStatisticsSnapshot.Bucket bucket = ClusterByStatisticsSnapshotSerde.deserializeBucket(duplicate);
            buckets.put(timeChunk, bucket);
            nextBucket = position + 12 + snapshotSize;
        }
        return new ClusterByStatisticsSnapshot(buckets, hasMultiValues);
    }

    static void serializeBucket(OutputStream outputStream, ClusterByStatisticsSnapshot.Bucket bucket) throws IOException {
        byte[] bucketKeyArray = bucket.getBucketKey().array();
        double bytesRetained = bucket.getBytesRetained();
        KeyCollectorSnapshot snapshot = bucket.getKeyCollectorSnapshot();
        byte[] serializedSnapshot = snapshot.getSerializer().serialize(snapshot);
        int length = 16 + bucketKeyArray.length + serializedSnapshot.length;
        outputStream.write(ByteBuffer.allocate(4 + length).putInt(length).putDouble(bytesRetained).putInt(bucketKeyArray.length).putInt(serializedSnapshot.length).put(bucketKeyArray).put(serializedSnapshot).array());
    }

    static ClusterByStatisticsSnapshot.Bucket deserializeBucket(ByteBuffer byteBuffer) {
        int position = byteBuffer.position();
        double bytesRetained = byteBuffer.getDouble(position + 0);
        int keyLength = byteBuffer.getInt(position + 8);
        int snapshotLength = byteBuffer.getInt(position + 12);
        ByteBuffer keyBuffer = byteBuffer.duplicate().order(byteBuffer.order()).position(position + 16).limit(position + 16 + keyLength);
        byte[] byteKey = new byte[keyLength];
        keyBuffer.get(byteKey);
        int snapshotOffset = position + 16 + keyLength;
        ByteBuffer snapshotBuffer = byteBuffer.duplicate().order(byteBuffer.order()).position(snapshotOffset).limit(snapshotOffset + snapshotLength);
        return new ClusterByStatisticsSnapshot.Bucket(RowKey.wrap((byte[])byteKey), KeyCollectorSnapshotDeserializer.deserialize(snapshotBuffer), bytesRetained);
    }

    private static void writeIntToStream(OutputStream outputStream, int integerToWrite) throws IOException {
        outputStream.write(ByteBuffer.allocate(4).putInt(integerToWrite).array());
    }

    private static void writeLongToStream(OutputStream outputStream, long longToWrite) throws IOException {
        outputStream.write(ByteBuffer.allocate(8).putLong(longToWrite).array());
    }
}

