/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.util;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.exec.SegmentSource;
import org.apache.druid.msq.indexing.MSQControllerTask;
import org.apache.druid.msq.indexing.MSQSpec;
import org.apache.druid.msq.indexing.destination.DataSourceMSQDestination;
import org.apache.druid.msq.util.MultiStageQueryContext;

public class MSQTaskQueryMakerUtils {
    public static final Set<String> SENSISTIVE_JSON_KEYS = ImmutableSet.of((Object)"accessKeyId", (Object)"secretAccessKey");
    public static final Set<Pattern> SENSITIVE_KEYS_REGEX_PATTERNS = SENSISTIVE_JSON_KEYS.stream().map(sensitiveKey -> Pattern.compile(StringUtils.format((String)"\\\\\"%s\\\\\"(\\s)*:(\\s)*(?<sensitive>\\{(\\s)*(\\S)+?(\\s)*\\})", (Object[])new Object[]{sensitiveKey}), 2)).collect(Collectors.toSet());

    public static String maskSensitiveJsonKeys(String sqlQuery) {
        StringBuilder maskedSqlQuery = new StringBuilder(sqlQuery);
        for (Pattern p : SENSITIVE_KEYS_REGEX_PATTERNS) {
            Matcher m = p.matcher(sqlQuery);
            while (m.find()) {
                String sensitiveData = m.group("sensitive");
                int start = maskedSqlQuery.indexOf(sensitiveData);
                int end = start + sensitiveData.length();
                maskedSqlQuery.replace(start, end, "<masked>");
            }
        }
        return maskedSqlQuery.toString();
    }

    public static void validateContextSortOrderColumnsExist(List<String> contextSortOrder, Set<String> allOutputColumns) {
        for (String column : contextSortOrder) {
            if (allOutputColumns.contains(column)) continue;
            throw InvalidSqlInput.exception((String)"Column[%s] from context parameter[%s] does not appear in the query output", (Object[])new Object[]{column, "segmentSortOrder"});
        }
    }

    public static void validateRealtimeReindex(MSQSpec querySpec) {
        SegmentSource segmentSources = MultiStageQueryContext.getSegmentSources(querySpec.getQuery().context());
        if (MSQControllerTask.isReplaceInputDataSourceTask(querySpec) && SegmentSource.REALTIME.equals((Object)segmentSources)) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("Cannot ingest into datasource[%s] since it is also being queried from, with REALTIME segments included. Ingest to a different datasource, or disable querying of realtime segments by modifying [%s] in the query context.", new Object[]{((DataSourceMSQDestination)querySpec.getDestination()).getDataSource(), "includeSegmentSource"});
        }
    }
}

