/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.pac4j;

import com.google.common.primitives.Ints;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class CustomSSLResourceRetriever
extends DefaultResourceRetriever {
    private SSLSocketFactory sslSocketFactory;

    public CustomSSLResourceRetriever(long readTimeout, SSLSocketFactory sslSocketFactory) {
        super(Ints.checkedCast((long)readTimeout), Ints.checkedCast((long)readTimeout));
        this.sslSocketFactory = sslSocketFactory;
    }

    protected HttpURLConnection openConnection(URL url) throws IOException {
        HttpURLConnection con = super.openConnection(url);
        if (this.sslSocketFactory != null && con instanceof HttpsURLConnection) {
            ((HttpsURLConnection)con).setSSLSocketFactory(this.sslSocketFactory);
        }
        return con;
    }
}

