/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.pac4j;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.metadata.PasswordProvider;

public class OIDCConfig {
    private static final String DEFAULT_SCOPE = "name";
    @JsonProperty
    private final String clientID;
    @JsonProperty
    private final PasswordProvider clientSecret;
    @JsonProperty
    private final String discoveryURI;
    @JsonProperty
    private final String oidcClaim;
    @JsonProperty
    private final String scope;

    @JsonCreator
    public OIDCConfig(@JsonProperty(value="clientID") String clientID, @JsonProperty(value="clientSecret") PasswordProvider clientSecret, @JsonProperty(value="discoveryURI") String discoveryURI, @JsonProperty(value="oidcClaim") String oidcClaim, @JsonProperty(value="scope") @Nullable String scope) {
        this.clientID = (String)Preconditions.checkNotNull((Object)clientID, (Object)"null clientID");
        this.clientSecret = (PasswordProvider)Preconditions.checkNotNull((Object)clientSecret, (Object)"null clientSecret");
        this.discoveryURI = (String)Preconditions.checkNotNull((Object)discoveryURI, (Object)"null discoveryURI");
        this.oidcClaim = oidcClaim == null ? DEFAULT_SCOPE : oidcClaim;
        this.scope = scope;
    }

    @JsonProperty
    public String getClientID() {
        return this.clientID;
    }

    @JsonProperty
    public PasswordProvider getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty
    public String getDiscoveryURI() {
        return this.discoveryURI;
    }

    @JsonProperty
    public String getOidcClaim() {
        return this.oidcClaim;
    }

    @JsonProperty
    public String getScope() {
        return this.scope;
    }
}

