/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.autoscaling.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.indexing.overlord.autoscaling.AutoScaler;
import org.apache.druid.indexing.overlord.autoscaling.AutoScalingData;
import org.apache.druid.indexing.overlord.autoscaling.SimpleWorkerProvisioningConfig;
import org.apache.druid.indexing.overlord.autoscaling.ec2.EC2EnvironmentConfig;
import org.apache.druid.indexing.overlord.autoscaling.ec2.EC2NodeData;
import org.apache.druid.java.util.emitter.EmittingLogger;

@JsonTypeName(value="ec2")
public class EC2AutoScaler
implements AutoScaler<EC2EnvironmentConfig> {
    private static final EmittingLogger log = new EmittingLogger(EC2AutoScaler.class);
    public static final int MAX_AWS_FILTER_VALUES = 100;
    private final int minNumWorkers;
    private final int maxNumWorkers;
    private final EC2EnvironmentConfig envConfig;
    private final AmazonEC2 amazonEC2Client;
    private final SimpleWorkerProvisioningConfig config;

    @JsonCreator
    public EC2AutoScaler(@JsonProperty(value="minNumWorkers") int minNumWorkers, @JsonProperty(value="maxNumWorkers") int maxNumWorkers, @JsonProperty(value="envConfig") EC2EnvironmentConfig envConfig, @JacksonInject AmazonEC2 amazonEC2Client, @JacksonInject SimpleWorkerProvisioningConfig config) {
        this.minNumWorkers = minNumWorkers;
        this.maxNumWorkers = maxNumWorkers;
        this.envConfig = envConfig;
        this.amazonEC2Client = amazonEC2Client;
        this.config = config;
    }

    @JsonProperty
    public int getMinNumWorkers() {
        return this.minNumWorkers;
    }

    @JsonProperty
    public int getMaxNumWorkers() {
        return this.maxNumWorkers;
    }

    @JsonProperty
    public EC2EnvironmentConfig getEnvConfig() {
        return this.envConfig;
    }

    public AutoScalingData provision() {
        try {
            EC2NodeData workerConfig = this.envConfig.getNodeData();
            String userDataBase64 = this.envConfig.getUserData() == null ? null : (this.config.getWorkerVersion() == null ? this.envConfig.getUserData().getUserDataBase64() : this.envConfig.getUserData().withVersion(this.config.getWorkerVersion()).getUserDataBase64());
            RunInstancesRequest request = new RunInstancesRequest(workerConfig.getAmiId(), Integer.valueOf(workerConfig.getMinInstances()), Integer.valueOf(workerConfig.getMaxInstances())).withInstanceType(workerConfig.getInstanceType()).withPlacement(new Placement(this.envConfig.getAvailabilityZone())).withKeyName(workerConfig.getKeyName()).withIamInstanceProfile(workerConfig.getIamProfile() == null ? null : workerConfig.getIamProfile().toIamInstanceProfileSpecification()).withUserData(userDataBase64);
            if (workerConfig.getAssociatePublicIpAddress() != null) {
                request.withNetworkInterfaces(new InstanceNetworkInterfaceSpecification[]{new InstanceNetworkInterfaceSpecification().withAssociatePublicIpAddress(workerConfig.getAssociatePublicIpAddress()).withSubnetId(workerConfig.getSubnetId()).withGroups(workerConfig.getSecurityGroupIds()).withDeviceIndex(Integer.valueOf(0))});
            } else {
                request.withSecurityGroupIds(workerConfig.getSecurityGroupIds()).withSubnetId(workerConfig.getSubnetId());
            }
            RunInstancesResult result = this.amazonEC2Client.runInstances(request);
            List instanceIds = Lists.transform((List)result.getReservation().getInstances(), (Function)new Function<Instance, String>(){

                public String apply(Instance input) {
                    return input.getInstanceId();
                }
            });
            log.info("Created instances: %s", new Object[]{instanceIds});
            return new AutoScalingData(Lists.transform((List)result.getReservation().getInstances(), (Function)new Function<Instance, String>(){

                public String apply(Instance input) {
                    return input.getInstanceId();
                }
            }));
        }
        catch (Exception e) {
            log.error((Throwable)e, "Unable to provision any EC2 instances.", new Object[0]);
            return null;
        }
    }

    public AutoScalingData terminate(List<String> ips) {
        if (ips.isEmpty()) {
            return new AutoScalingData(new ArrayList());
        }
        DescribeInstancesResult result = this.amazonEC2Client.describeInstances(new DescribeInstancesRequest().withFilters(new Filter[]{new Filter("private-ip-address", ips)}));
        ArrayList instances = new ArrayList();
        for (Reservation reservation : result.getReservations()) {
            instances.addAll(reservation.getInstances());
        }
        try {
            return this.terminateWithIds(Lists.transform(instances, (Function)new Function<Instance, String>(){

                public String apply(Instance input) {
                    return input.getInstanceId();
                }
            }));
        }
        catch (Exception e) {
            log.error((Throwable)e, "Unable to terminate any instances.", new Object[0]);
            return null;
        }
    }

    public AutoScalingData terminateWithIds(List<String> ids) {
        if (ids.isEmpty()) {
            return new AutoScalingData(new ArrayList());
        }
        try {
            log.info("Terminating instances[%s]", new Object[]{ids});
            this.amazonEC2Client.terminateInstances(new TerminateInstancesRequest(ids));
            return new AutoScalingData(ids);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Unable to terminate any instances.", new Object[0]);
            return null;
        }
    }

    public List<String> ipToIdLookup(List<String> ips) {
        ImmutableList retVal = FluentIterable.from((Iterable)Lists.partition(ips, (int)100)).transformAndConcat((Function)new Function<List<String>, Iterable<Reservation>>(){

            public Iterable<Reservation> apply(List<String> input) {
                return EC2AutoScaler.this.amazonEC2Client.describeInstances(new DescribeInstancesRequest().withFilters(new Filter[]{new Filter("private-ip-address", input)})).getReservations();
            }
        }).transformAndConcat((Function)new Function<Reservation, Iterable<Instance>>(){

            public Iterable<Instance> apply(Reservation reservation) {
                return reservation.getInstances();
            }
        }).transform((Function)new Function<Instance, String>(){

            public String apply(Instance instance) {
                return instance.getInstanceId();
            }
        }).toList();
        log.debug("Performing lookup: %s --> %s", new Object[]{ips, retVal});
        return retVal;
    }

    public List<String> idToIpLookup(List<String> nodeIds) {
        ImmutableList retVal = FluentIterable.from((Iterable)Lists.partition(nodeIds, (int)100)).transformAndConcat((Function)new Function<List<String>, Iterable<Reservation>>(){

            public Iterable<Reservation> apply(List<String> input) {
                return EC2AutoScaler.this.amazonEC2Client.describeInstances(new DescribeInstancesRequest().withFilters(new Filter[]{new Filter("instance-id", input)})).getReservations();
            }
        }).transformAndConcat((Function)new Function<Reservation, Iterable<Instance>>(){

            public Iterable<Instance> apply(Reservation reservation) {
                return reservation.getInstances();
            }
        }).transform((Function)new Function<Instance, String>(){

            public String apply(Instance instance) {
                return instance.getPrivateIpAddress();
            }
        }).toList();
        log.debug("Performing lookup: %s --> %s", new Object[]{nodeIds, retVal});
        return retVal;
    }

    public String toString() {
        return "EC2AutoScaler{envConfig=" + this.envConfig + ", maxNumWorkers=" + this.maxNumWorkers + ", minNumWorkers=" + this.minNumWorkers + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EC2AutoScaler that = (EC2AutoScaler)o;
        if (this.maxNumWorkers != that.maxNumWorkers) {
            return false;
        }
        if (this.minNumWorkers != that.minNumWorkers) {
            return false;
        }
        return !(this.envConfig != null ? !this.envConfig.equals(that.envConfig) : that.envConfig != null);
    }

    public int hashCode() {
        int result = this.minNumWorkers;
        result = 31 * result + this.maxNumWorkers;
        result = 31 * result + (this.envConfig != null ? this.envConfig.hashCode() : 0);
        return result;
    }
}

