/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.s3a.statistics.StatisticTypeEnum;

@InterfaceStability.Unstable
public enum Statistic {
    ACTION_EXECUTOR_ACQUIRED("action_executor_acquired", "Executor acquired.", StatisticTypeEnum.TYPE_DURATION),
    ACTION_HTTP_HEAD_REQUEST("action_http_head_request", "HEAD request.", StatisticTypeEnum.TYPE_DURATION),
    ACTION_FILE_OPENED("action_file_opened", "File opened.", StatisticTypeEnum.TYPE_DURATION),
    ACTION_HTTP_GET_REQUEST("action_http_get_request", "GET request.", StatisticTypeEnum.TYPE_DURATION),
    DIRECTORIES_CREATED("directories_created", "Total number of directories created through the object store.", StatisticTypeEnum.TYPE_COUNTER),
    DIRECTORIES_DELETED("directories_deleted", "Total number of directories deleted through the object store.", StatisticTypeEnum.TYPE_COUNTER),
    FILES_COPIED("files_copied", "Total number of files copied within the object store.", StatisticTypeEnum.TYPE_COUNTER),
    FILES_COPIED_BYTES("files_copied_bytes", "Total number of bytes copied within the object store.", StatisticTypeEnum.TYPE_COUNTER),
    FILES_CREATED("files_created", "Total number of files created through the object store.", StatisticTypeEnum.TYPE_COUNTER),
    FILES_DELETED("files_deleted", "Total number of files deleted from the object store.", StatisticTypeEnum.TYPE_COUNTER),
    FILES_DELETE_REJECTED("files_delete_rejected", "Total number of files whose delete request was rejected", StatisticTypeEnum.TYPE_COUNTER),
    FAKE_DIRECTORIES_CREATED("fake_directories_created", "Total number of fake directory entries created in the object store.", StatisticTypeEnum.TYPE_COUNTER),
    FAKE_DIRECTORIES_DELETED("fake_directories_deleted", "Total number of fake directory deletes submitted to object store.", StatisticTypeEnum.TYPE_COUNTER),
    IGNORED_ERRORS("ignored_errors", "Errors caught and ignored", StatisticTypeEnum.TYPE_COUNTER),
    INVOCATION_ABORT("op_abort", "Calls of abort()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_ACCESS("op_access", "Calls of access()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_COPY_FROM_LOCAL_FILE("op_copy_from_local_file", "Calls of copyFromLocalFile()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_CREATE("op_create", "Calls of create()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_CREATE_FILE("op_createfile", "Calls of createFile()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_CREATE_NON_RECURSIVE("op_create_non_recursive", "Calls of createNonRecursive()", StatisticTypeEnum.TYPE_COUNTER),
    INVOCATION_DELETE("op_delete", "Calls of delete()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_EXISTS("op_exists", "Calls of exists()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_GET_CONTENT_SUMMARY("op_get_content_summary", "Calls of getContentSummary()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_GET_DELEGATION_TOKEN("op_get_delegation_token", "Calls of getDelegationToken()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_GET_FILE_CHECKSUM("op_get_file_checksum", "Calls of getFileChecksum()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_GET_FILE_STATUS("op_get_file_status", "Calls of getFileStatus()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_GLOB_STATUS("op_glob_status", "Calls of globStatus()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_IS_DIRECTORY("op_is_directory", "Calls of isDirectory()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_IS_FILE("op_is_file", "Calls of isFile()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_HFLUSH("op_hflush", "Calls of hflush()", StatisticTypeEnum.TYPE_COUNTER),
    INVOCATION_HSYNC("op_hsync", "Calls of hsync()", StatisticTypeEnum.TYPE_COUNTER),
    INVOCATION_LIST_FILES("op_list_files", "Calls of listFiles()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_LIST_LOCATED_STATUS("op_list_located_status", "Calls of listLocatedStatus()", StatisticTypeEnum.TYPE_COUNTER),
    INVOCATION_LIST_STATUS("op_list_status", "Calls of listStatus()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_MKDIRS("op_mkdirs", "Calls of mkdirs()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_OPEN("op_open", "Calls of open()", StatisticTypeEnum.TYPE_COUNTER),
    INVOCATION_OPENFILE("op_openfile", "Calls of openFile()", StatisticTypeEnum.TYPE_COUNTER),
    INVOCATION_RENAME("op_rename", "Calls of rename()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_XATTR_GET_MAP("op_xattr_get_map", "Calls of getXAttrs(Path path)", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_XATTR_GET_NAMED("op_xattr_get_named", "Calls of getXAttr(Path, String)", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_XATTR_GET_NAMED_MAP("op_xattr_get_named_map", "Calls of xattr()", StatisticTypeEnum.TYPE_DURATION),
    INVOCATION_OP_XATTR_LIST("op_xattr_list", "Calls of getXAttrs(Path path, List<String> names)", StatisticTypeEnum.TYPE_DURATION),
    OBJECT_COPY_REQUESTS("object_copy_requests", "Object copy requests", StatisticTypeEnum.TYPE_COUNTER),
    OBJECT_DELETE_REQUEST("object_delete_request", "Object delete requests", StatisticTypeEnum.TYPE_DURATION),
    OBJECT_BULK_DELETE_REQUEST("object_bulk_delete_request", "Object bulk delete requests", StatisticTypeEnum.TYPE_DURATION),
    OBJECT_DELETE_OBJECTS("object_delete_objects", "Objects deleted in delete requests", StatisticTypeEnum.TYPE_COUNTER),
    OBJECT_LIST_REQUEST("object_list_request", "Count of object listings made", StatisticTypeEnum.TYPE_DURATION),
    OBJECT_CONTINUE_LIST_REQUESTS("object_continue_list_request", "Count of continued object listings made", StatisticTypeEnum.TYPE_DURATION),
    OBJECT_METADATA_REQUESTS("object_metadata_request", "Count of requests for object metadata", StatisticTypeEnum.TYPE_COUNTER),
    OBJECT_MULTIPART_UPLOAD_INITIATED("object_multipart_initiated", "Object multipart upload initiated", StatisticTypeEnum.TYPE_DURATION),
    OBJECT_MULTIPART_UPLOAD_ABORTED("object_multipart_aborted", "Object multipart upload aborted", StatisticTypeEnum.TYPE_DURATION),
    OBJECT_PUT_REQUESTS("object_put_request", "Object put/multipart upload count", StatisticTypeEnum.TYPE_DURATION),
    OBJECT_PUT_REQUESTS_COMPLETED("object_put_request_completed", "Object put/multipart upload completed count", StatisticTypeEnum.TYPE_COUNTER),
    OBJECT_PUT_REQUESTS_ACTIVE("object_put_request_active", "Current number of active put requests", StatisticTypeEnum.TYPE_GAUGE),
    OBJECT_PUT_BYTES("object_put_bytes", "number of bytes uploaded", StatisticTypeEnum.TYPE_COUNTER),
    OBJECT_PUT_BYTES_PENDING("object_put_bytes_pending", "number of bytes queued for upload/being actively uploaded", StatisticTypeEnum.TYPE_GAUGE),
    OBJECT_SELECT_REQUESTS("object_select_requests", "Count of S3 Select requests issued", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_ABORTED("stream_aborted", "Count of times the TCP stream was aborted", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_BYTES("stream_read_bytes", "Bytes read from an input stream in read() calls", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_BYTES_DISCARDED_ABORT("stream_read_bytes_discarded_in_abort", "Count of bytes discarded by aborting an input stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_BYTES_READ_CLOSE("stream_read_bytes_discarded_in_close", "Count of bytes read and discarded when closing an input stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_CLOSED("stream_read_closed", "Count of times the TCP stream was closed", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_CLOSE_OPERATIONS("stream_read_close_operations", "Total count of times an attempt to close an input stream was made", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_EXCEPTIONS("stream_read_exceptions", "Count of exceptions raised during input stream reads", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_FULLY_OPERATIONS("stream_read_fully_operations", "Count of readFully() operations in an input stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_OPENED("stream_read_opened", "Total count of times an input stream to object store data was opened", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_OPERATIONS("stream_read_operations", "Count of read() operations in an input stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_VECTORED_OPERATIONS("stream_read_vectored_operations", "Count of readVectored() operations in an input stream.", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_VECTORED_READ_BYTES_DISCARDED("stream_read_vectored_read_bytes_discarded", "Count of bytes discarded during readVectored() operation. in an input stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_VECTORED_INCOMING_RANGES("stream_read_vectored_incoming_ranges", "Count of incoming file ranges during readVectored() operation.", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_VECTORED_COMBINED_RANGES("stream_read_vectored_combined_ranges", "Count of combined file ranges during readVectored() operation.", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_REMOTE_STREAM_ABORTED("stream_read_remote_stream_aborted", "Duration of aborting a remote stream during stream IO", StatisticTypeEnum.TYPE_DURATION),
    STREAM_READ_REMOTE_STREAM_CLOSED("stream_read_remote_stream_drain", "Duration of closing a remote stream during stream IO", StatisticTypeEnum.TYPE_DURATION),
    STREAM_READ_OPERATIONS_INCOMPLETE("stream_read_operations_incomplete", "Count of incomplete read() operations in an input stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_VERSION_MISMATCHES("stream_read_version_mismatches", "Count of version mismatches encountered while reading an input stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_SEEK_BACKWARD_OPERATIONS("stream_read_seek_backward_operations", "Count of executed seek operations which went backwards in a stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_SEEK_BYTES_BACKWARDS("stream_read_bytes_backwards_on_seek", "Count of bytes moved backwards during seek operations in an input stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_SEEK_BYTES_DISCARDED("stream_read_seek_bytes_discarded", "Count of bytes read and discarded during seek() in an input stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_SEEK_BYTES_SKIPPED("stream_read_seek_bytes_skipped", "Count of bytes skipped during forward seek operations an input stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_SEEK_FORWARD_OPERATIONS("stream_read_seek_forward_operations", "Count of executed seek operations which went forward in an input stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_SEEK_OPERATIONS("stream_read_seek_operations", "Count of seek operations in an input stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_SEEK_POLICY_CHANGED("stream_read_seek_policy_changed", "Count of times the seek policy was dynamically changed in an input stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_TOTAL_BYTES("stream_read_total_bytes", "Total count of bytes read from an input stream", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_UNBUFFERED("stream_read_unbuffered", "Total count of input stream unbuffering operations", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_READ_BLOCKS_IN_FILE_CACHE("stream_read_blocks_in_cache", "Gauge of blocks in disk cache", StatisticTypeEnum.TYPE_GAUGE),
    STREAM_READ_ACTIVE_PREFETCH_OPERATIONS("stream_read_active_prefetch_operations", "Gauge of active prefetches", StatisticTypeEnum.TYPE_GAUGE),
    STREAM_READ_ACTIVE_MEMORY_IN_USE("stream_read_active_memory_in_use", "Gauge of active memory in use", StatisticTypeEnum.TYPE_GAUGE),
    STREAM_WRITE_EXCEPTIONS("stream_write_exceptions", "Count of stream write failures reported", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_WRITE_EXCEPTIONS_COMPLETING_UPLOADS("stream_write_exceptions_completing_upload", "Count of failures when finalizing a multipart upload", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_WRITE_BLOCK_UPLOADS("stream_write_block_uploads", "Count of block/partition uploads completed", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_WRITE_BLOCK_UPLOADS_ACTIVE("stream_write_block_uploads_active", "Count of block/partition uploads active", StatisticTypeEnum.TYPE_GAUGE),
    STREAM_WRITE_BLOCK_UPLOADS_COMMITTED("stream_write_block_uploads_committed", "Count of number of block uploads committed", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_WRITE_BLOCK_UPLOADS_ABORTED("stream_write_block_uploads_aborted", "Count of number of block uploads aborted", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_WRITE_BLOCK_UPLOADS_PENDING("stream_write_block_uploads_pending", "Gauge of block/partitions uploads queued to be written", StatisticTypeEnum.TYPE_GAUGE),
    STREAM_WRITE_BLOCK_UPLOADS_BYTES_PENDING("stream_write_block_uploads_data_pending", "Gauge of data queued to be written", StatisticTypeEnum.TYPE_GAUGE),
    STREAM_WRITE_TOTAL_TIME("stream_write_total_time", "Count of total time taken for uploads to complete", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_WRITE_TOTAL_DATA("stream_write_total_data", "Count of total data uploaded", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_WRITE_BYTES("stream_write_bytes", "Count of bytes written to output stream (including all not yet uploaded)", StatisticTypeEnum.TYPE_COUNTER),
    STREAM_WRITE_QUEUE_DURATION("stream_write_queue_duration", "Total queue duration of all block uploads", StatisticTypeEnum.TYPE_DURATION),
    COMMITTER_COMMITS_CREATED("committer_commits_created", "Count of files to commit created", StatisticTypeEnum.TYPE_COUNTER),
    COMMITTER_COMMITS_COMPLETED("committer_commits_completed", "Count of files committed", StatisticTypeEnum.TYPE_COUNTER),
    COMMITTER_COMMIT_JOB("committer_commit_job", "Duration Tracking of time to commit an entire job", StatisticTypeEnum.TYPE_DURATION),
    COMMITTER_JOBS_SUCCEEDED("committer_jobs_completed", "Count of successful jobs", StatisticTypeEnum.TYPE_COUNTER),
    COMMITTER_JOBS_FAILED("committer_jobs_failed", "Count of failed jobs", StatisticTypeEnum.TYPE_COUNTER),
    COMMITTER_TASKS_SUCCEEDED("committer_tasks_completed", "Count of successful tasks", StatisticTypeEnum.TYPE_COUNTER),
    COMMITTER_TASKS_FAILED("committer_tasks_failed", "Count of failed tasks", StatisticTypeEnum.TYPE_COUNTER),
    COMMITTER_BYTES_COMMITTED("committer_bytes_committed", "Amount of data committed", StatisticTypeEnum.TYPE_COUNTER),
    COMMITTER_BYTES_UPLOADED("committer_bytes_uploaded", "Count of bytes uploaded duing commit operations", StatisticTypeEnum.TYPE_COUNTER),
    COMMITTER_COMMITS_FAILED("committer_commits.failures", "Count of commits failed", StatisticTypeEnum.TYPE_COUNTER),
    COMMITTER_COMMITS_ABORTED("committer_commits_aborted", "Count of commits aborted", StatisticTypeEnum.TYPE_COUNTER),
    COMMITTER_COMMITS_REVERTED("committer_commits_reverted", "Count of commits reverted", StatisticTypeEnum.TYPE_COUNTER),
    COMMITTER_LOAD_SINGLE_PENDING_FILE("committer_load_single_pending_file", "Duration to load a single pending file in task commit", StatisticTypeEnum.TYPE_DURATION),
    COMMITTER_MAGIC_FILES_CREATED("committer_magic_files_created", "Count of files created under 'magic' paths", StatisticTypeEnum.TYPE_COUNTER),
    COMMITTER_MAGIC_MARKER_PUT("committer_magic_marker_put", "Duration Tracking of marker files created under 'magic' paths", StatisticTypeEnum.TYPE_DURATION),
    COMMITTER_MATERIALIZE_FILE("committer_materialize_file", "Duration Tracking of time to materialize a file in job commit", StatisticTypeEnum.TYPE_DURATION),
    COMMITTER_STAGE_FILE_UPLOAD("committer_stage_file_upload", "Duration Tracking of files uploaded from a local staging path", StatisticTypeEnum.TYPE_DURATION),
    STORE_EXISTS_PROBE("store_exists_probe", "Store Existence Probe", StatisticTypeEnum.TYPE_DURATION),
    STORE_IO_REQUEST("store_io_request", "requests made of the remote store", StatisticTypeEnum.TYPE_COUNTER),
    STORE_IO_RETRY("store_io_retry", "retried requests made of the remote store", StatisticTypeEnum.TYPE_COUNTER),
    STORE_IO_THROTTLED("store_io_throttled", "Requests throttled and retried", StatisticTypeEnum.TYPE_COUNTER),
    STORE_IO_THROTTLE_RATE("store_io_throttle_rate", "Rate of S3 request throttling", StatisticTypeEnum.TYPE_QUANTILE),
    DELEGATION_TOKENS_ISSUED("delegation_tokens_issued", "Count of delegation tokens issued", StatisticTypeEnum.TYPE_DURATION),
    MULTIPART_UPLOAD_INSTANTIATED("multipart_instantiated", "Multipart Uploader Instantiated", StatisticTypeEnum.TYPE_COUNTER),
    MULTIPART_UPLOAD_PART_PUT("multipart_upload_part_put", "Multipart Part Put Operation", StatisticTypeEnum.TYPE_COUNTER),
    MULTIPART_UPLOAD_PART_PUT_BYTES("multipart_upload_part_put_bytes", "Multipart Part Put Bytes", StatisticTypeEnum.TYPE_COUNTER),
    MULTIPART_UPLOAD_ABORTED("multipart_upload_aborted", "Multipart Upload Aborted", StatisticTypeEnum.TYPE_COUNTER),
    MULTIPART_UPLOAD_ABORT_UNDER_PATH_INVOKED("multipart_upload_abort_under_path_invoked", "Multipart Upload Abort Unner Path Invoked", StatisticTypeEnum.TYPE_COUNTER),
    MULTIPART_UPLOAD_COMPLETED("multipart_upload_completed", "Multipart Upload Completed", StatisticTypeEnum.TYPE_COUNTER),
    MULTIPART_UPLOAD_LIST("multipart_upload_list", "Multipart Upload List", StatisticTypeEnum.TYPE_DURATION),
    MULTIPART_UPLOAD_STARTED("multipart_upload_started", "Multipart Upload Started", StatisticTypeEnum.TYPE_COUNTER),
    AUDIT_ACCESS_CHECK_FAILURE("audit_access_check_failure", "Audit access check was rejected", StatisticTypeEnum.TYPE_COUNTER),
    AUDIT_SPAN_CREATION("audit_span_creation", "Audit Span Created", StatisticTypeEnum.TYPE_COUNTER),
    AUDIT_FAILURE("audit_failure", "Audit failure/rejection", StatisticTypeEnum.TYPE_COUNTER),
    AUDIT_REQUEST_EXECUTION("audit_request_execution", "AWS request made", StatisticTypeEnum.TYPE_COUNTER),
    CLIENT_SIDE_ENCRYPTION_ENABLED("client_side_encryption_enabled", "gauge to indicate if client side encryption is enabled", StatisticTypeEnum.TYPE_GAUGE);

    private static final Map<String, Statistic> SYMBOL_MAP;
    private final String symbol;
    private final String description;
    private final StatisticTypeEnum type;

    private Statistic(String symbol, String description, StatisticTypeEnum type) {
        this.symbol = symbol;
        this.description = description;
        this.type = type;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public static Statistic fromSymbol(String symbol) {
        return SYMBOL_MAP.get(symbol);
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.symbol;
    }

    public StatisticTypeEnum getType() {
        return this.type;
    }

    static {
        SYMBOL_MAP = new HashMap<String, Statistic>(Statistic.values().length);
        for (Statistic stat : Statistic.values()) {
            SYMBOL_MAP.put(stat.getSymbol(), stat);
        }
    }
}

