/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.spatial.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.collections.spatial.ImmutableFloatPoint;
import org.apache.druid.collections.spatial.RTreeUtils;
import org.apache.druid.collections.spatial.search.RectangularBound;

public class RadiusBound
extends RectangularBound {
    private static final byte CACHE_TYPE_ID = 1;
    private final float[] coords;
    private final float radius;
    private final RadiusUnit radiusUnit;

    @JsonCreator
    public RadiusBound(@JsonProperty(value="coords") float[] coords, @JsonProperty(value="radius") float radius, @JsonProperty(value="limit") int limit, @JsonProperty(value="radiusUnit") @Nullable RadiusUnit radiusUnit) {
        super(RadiusBound.getMinCoords(coords, radius), RadiusBound.getMaxCoords(coords, radius), limit);
        this.coords = coords;
        this.radius = radius;
        this.radiusUnit = radiusUnit == null ? RadiusUnit.euclidean : radiusUnit;
    }

    public RadiusBound(float[] coords, float radius, int limit) {
        this(coords, radius, limit, null);
    }

    public RadiusBound(float[] coords, float radius, RadiusUnit radiusUnit) {
        this(coords, radius, 0, radiusUnit);
    }

    public RadiusBound(float[] coords, float radius) {
        this(coords, radius, 0, null);
    }

    private static float[] getMinCoords(float[] coords, float radius) {
        float[] retVal = new float[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            retVal[i] = coords[i] - radius;
        }
        return retVal;
    }

    private static float[] getMaxCoords(float[] coords, float radius) {
        float[] retVal = new float[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            retVal[i] = coords[i] + radius;
        }
        return retVal;
    }

    @JsonProperty
    public float[] getCoords() {
        return this.coords;
    }

    @JsonProperty
    public float getRadius() {
        return this.radius;
    }

    @JsonProperty
    public RadiusUnit getRadiusUnit() {
        return this.radiusUnit;
    }

    @Override
    public boolean contains(float[] otherCoords) {
        if (otherCoords.length < 2 || this.coords.length < 2) {
            return false;
        }
        if (this.radiusUnit == RadiusUnit.euclidean) {
            double total = 0.0;
            for (int i = 0; i < this.coords.length; ++i) {
                total += Math.pow(otherCoords[i] - this.coords[i], 2.0);
            }
            return total <= Math.pow(this.radius, 2.0);
        }
        double radiusInMeters = this.getRadius() * this.radiusUnit.getMetersMultiFactor();
        double distance = RTreeUtils.calculateHaversineDistance(this.coords[0], this.coords[1], otherCoords[0], otherCoords[1]);
        return distance <= radiusInMeters;
    }

    @Override
    public Iterable<ImmutableFloatPoint> filter(Iterable<ImmutableFloatPoint> points) {
        return Iterables.filter(points, (Predicate)new Predicate<ImmutableFloatPoint>(){

            public boolean apply(ImmutableFloatPoint point) {
                return RadiusBound.this.contains(point.getCoords());
            }
        });
    }

    @Override
    public byte[] getCacheKey() {
        ByteBuffer minCoordsBuffer = ByteBuffer.allocate(this.coords.length * 4);
        minCoordsBuffer.asFloatBuffer().put(this.coords);
        byte[] minCoordsCacheKey = minCoordsBuffer.array();
        ByteBuffer cacheKey = ByteBuffer.allocate(1 + minCoordsCacheKey.length + 4 + 4).put(minCoordsCacheKey).putFloat(this.radius).putInt(this.getLimit()).put((byte)1);
        return cacheKey.array();
    }

    public static enum RadiusUnit {
        meters(1.0f),
        euclidean(1.0f),
        miles(1609.344f),
        kilometers(1000.0f);

        float metersMultiFactor;

        private RadiusUnit(float mmf) {
            this.metersMultiFactor = mmf;
        }

        public float getMetersMultiFactor() {
            return this.metersMultiFactor;
        }
    }
}

