/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFileAttribute;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.java.util.common.HumanReadableBytes;

public class MaxSizeSplitHintSpec
implements SplitHintSpec {
    public static final String TYPE = "maxSize";
    @VisibleForTesting
    static final HumanReadableBytes DEFAULT_MAX_SPLIT_SIZE = new HumanReadableBytes("1GiB");
    @VisibleForTesting
    static final int DEFAULT_MAX_NUM_FILES = 1000;
    private final HumanReadableBytes maxSplitSize;
    private final int maxNumFiles;

    @JsonCreator
    public MaxSizeSplitHintSpec(@JsonProperty(value="maxSplitSize") @Nullable HumanReadableBytes maxSplitSize, @JsonProperty(value="maxNumFiles") @Nullable Integer maxNumFiles) {
        this.maxSplitSize = maxSplitSize == null ? DEFAULT_MAX_SPLIT_SIZE : maxSplitSize;
        this.maxNumFiles = maxNumFiles == null ? 1000 : maxNumFiles;
        Preconditions.checkArgument((this.maxSplitSize.getBytes() > 0L ? 1 : 0) != 0, (Object)"maxSplitSize should be larger than 0");
        Preconditions.checkArgument((this.maxNumFiles > 0 ? 1 : 0) != 0, (Object)"maxNumFiles should be larger than 0");
    }

    @VisibleForTesting
    public MaxSizeSplitHintSpec(long maxSplitSize, @Nullable Integer maxNumFiles) {
        this(new HumanReadableBytes(maxSplitSize), maxNumFiles);
    }

    @JsonProperty
    public HumanReadableBytes getMaxSplitSize() {
        return this.maxSplitSize;
    }

    @JsonProperty
    public int getMaxNumFiles() {
        return this.maxNumFiles;
    }

    @Override
    public <T> Iterator<List<T>> split(final Iterator<T> inputIterator, final Function<T, InputFileAttribute> inputAttributeExtractor) {
        return new Iterator<List<T>>(){
            private final long maxSplitSizeBytes;
            private T peeking;
            {
                this.maxSplitSizeBytes = MaxSizeSplitHintSpec.this.maxSplitSize.getBytes();
            }

            @Override
            public boolean hasNext() {
                return this.peeking != null || inputIterator.hasNext();
            }

            @Override
            public List<T> next() {
                long size;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ArrayList current = new ArrayList();
                for (long splitSize = 0L; splitSize < this.maxSplitSizeBytes && (this.peeking != null || inputIterator.hasNext()); splitSize += size) {
                    if (this.peeking == null) {
                        this.peeking = inputIterator.next();
                    }
                    size = ((InputFileAttribute)inputAttributeExtractor.apply(this.peeking)).getSize();
                    if (!current.isEmpty() && (splitSize + size >= this.maxSplitSizeBytes || current.size() >= MaxSizeSplitHintSpec.this.maxNumFiles)) break;
                    current.add(this.peeking);
                    this.peeking = null;
                }
                assert (!current.isEmpty());
                return current;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaxSizeSplitHintSpec that = (MaxSizeSplitHintSpec)o;
        return this.maxNumFiles == that.maxNumFiles && Objects.equals(this.maxSplitSize, that.maxSplitSize);
    }

    public int hashCode() {
        return Objects.hash(this.maxSplitSize, this.maxNumFiles);
    }
}

