/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame;

import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.java.util.common.ISE;

public enum FrameType {
    COLUMNAR(17),
    ROW_BASED(18);

    private final byte versionByte;

    @Nullable
    public static FrameType forVersion(byte versionByte) {
        for (FrameType type : FrameType.values()) {
            if (type.version() != versionByte) continue;
            return type;
        }
        return null;
    }

    private FrameType(byte magicByte) {
        this.versionByte = magicByte;
    }

    public byte version() {
        return this.versionByte;
    }

    public Frame ensureType(Frame frame) {
        if (frame == null) {
            throw new NullPointerException("Null frame");
        }
        if (frame.type() != this) {
            throw new ISE("Frame type must be [%s], but was [%s]", new Object[]{this, frame.type()});
        }
        return frame;
    }
}

