/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.field.NumericFieldWriter;
import org.apache.druid.frame.field.TransformUtils;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;

public class DoubleFieldWriter
extends NumericFieldWriter {
    private final BaseDoubleColumnValueSelector selector;

    public static DoubleFieldWriter forPrimitive(BaseDoubleColumnValueSelector selector) {
        return new DoubleFieldWriter(selector, false);
    }

    public static DoubleFieldWriter forArray(BaseDoubleColumnValueSelector selector) {
        return new DoubleFieldWriter(selector, true);
    }

    private DoubleFieldWriter(BaseDoubleColumnValueSelector selector, boolean forArray) {
        super(selector, forArray);
        this.selector = selector;
    }

    @Override
    public int getNumericSizeBytes() {
        return 8;
    }

    @Override
    public void writeSelectorToMemory(WritableMemory memory, long position) {
        this.writeToMemory(memory, position, this.selector.getDouble());
    }

    @Override
    public void writeNullToMemory(WritableMemory memory, long position) {
        this.writeToMemory(memory, position, 0.0);
    }

    private void writeToMemory(WritableMemory memory, long position, double value) {
        memory.putLong(position, TransformUtils.transformFromDouble(value));
    }
}

