/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.segment.BaseNullableColumnValueSelector;

public abstract class NumericFieldWriter
implements FieldWriter {
    public static final byte NULL_BYTE = 0;
    public static final byte NOT_NULL_BYTE = 1;
    public static final byte ARRAY_ELEMENT_NULL_BYTE = 1;
    public static final byte ARRAY_ELEMENT_NOT_NULL_BYTE = 2;
    private final BaseNullableColumnValueSelector selector;
    private final byte nullIndicatorByte;
    private final byte notNullIndicatorByte;

    public NumericFieldWriter(BaseNullableColumnValueSelector selector, boolean forArray) {
        this.selector = selector;
        if (!forArray) {
            this.nullIndicatorByte = 0;
            this.notNullIndicatorByte = 1;
        } else {
            this.nullIndicatorByte = 1;
            this.notNullIndicatorByte = (byte)2;
        }
    }

    @Override
    public long writeTo(WritableMemory memory, long position, long maxSize) {
        int size = this.getNumericSizeBytes() + 1;
        if (maxSize < (long)size) {
            return -1L;
        }
        if (this.selector.isNull()) {
            memory.putByte(position, this.nullIndicatorByte);
            this.writeNullToMemory(memory, position + 1L);
        } else {
            memory.putByte(position, this.notNullIndicatorByte);
            this.writeSelectorToMemory(memory, position + 1L);
        }
        return size;
    }

    @Override
    public void close() {
    }

    public abstract int getNumericSizeBytes();

    public abstract void writeSelectorToMemory(WritableMemory var1, long var2);

    public abstract void writeNullToMemory(WritableMemory var1, long var2);
}

