/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.segment.row;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.MemoryRange;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.field.RowMemoryFieldPointer;
import org.apache.druid.frame.segment.row.ReadableFrameRowPointer;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.RowIdSupplier;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class FrameColumnSelectorFactory
implements ColumnSelectorFactory,
RowIdSupplier {
    public static final String ROW_SIGNATURE_COLUMN = "___druid_frame_row_signature";
    public static final String ROW_MEMORY_COLUMN = "___druid_frame_row_mem";
    private final Memory dataRegion;
    private final RowSignature frameSignature;
    private final List<FieldReader> fieldReaders;
    private final ReadableFrameRowPointer rowPointer;

    public FrameColumnSelectorFactory(Frame frame, RowSignature frameSignature, List<FieldReader> fieldReaders, ReadableFrameRowPointer rowPointer) {
        this.dataRegion = FrameType.ROW_BASED.ensureType(frame).region(1);
        this.frameSignature = frameSignature;
        this.fieldReaders = fieldReaders;
        this.rowPointer = rowPointer;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(dimensionSpec));
    }

    @Override
    public ColumnValueSelector makeColumnValueSelector(String columnName) {
        if (ROW_SIGNATURE_COLUMN.equals(columnName)) {
            return new RowSignatureSelector(this.frameSignature);
        }
        if (ROW_MEMORY_COLUMN.equals(columnName)) {
            return new RowMemorySelector(this.dataRegion, this.rowPointer);
        }
        int columnNumber = this.frameSignature.indexOf(columnName);
        if (columnNumber < 0) {
            return NilColumnValueSelector.instance();
        }
        RowMemoryFieldPointer fieldPointer = new RowMemoryFieldPointer(this.dataRegion, this.rowPointer, columnNumber, this.fieldReaders.size());
        return this.fieldReaders.get(columnNumber).makeColumnValueSelector(this.dataRegion, fieldPointer);
    }

    @Override
    @Nullable
    public RowIdSupplier getRowIdSupplier() {
        return this;
    }

    @Override
    public long getRowId() {
        return this.rowPointer.position();
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        if (ROW_SIGNATURE_COLUMN.equals(column) || ROW_MEMORY_COLUMN.equals(column)) {
            return ColumnCapabilitiesImpl.createDefault().setType(ColumnType.UNKNOWN_COMPLEX);
        }
        return this.frameSignature.getColumnCapabilities(column);
    }

    private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
        int columnNumber = this.frameSignature.indexOf(dimensionSpec.getDimension());
        if (columnNumber < 0) {
            return DimensionSelector.constant(null, dimensionSpec.getExtractionFn());
        }
        RowMemoryFieldPointer fieldPointer = new RowMemoryFieldPointer(this.dataRegion, this.rowPointer, columnNumber, this.fieldReaders.size());
        return this.fieldReaders.get(columnNumber).makeDimensionSelector(this.dataRegion, fieldPointer, dimensionSpec.getExtractionFn());
    }

    private static class RowSignatureSelector
    extends ObjectColumnSelector<RowSignature> {
        private final RowSignature signature;

        public RowSignatureSelector(RowSignature signature) {
            this.signature = signature;
        }

        @Override
        public RowSignature getObject() {
            return this.signature;
        }

        @Override
        public Class<? extends RowSignature> classOfObject() {
            return RowSignature.class;
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }
    }

    private static class RowMemorySelector
    extends ObjectColumnSelector<MemoryRange<Memory>> {
        private final Memory frameDataRegion;
        private final ReadableFrameRowPointer rowPointer;
        private final MemoryRange<Memory> retVal;

        public RowMemorySelector(Memory frameDataRegion, ReadableFrameRowPointer rowPointer) {
            this.frameDataRegion = frameDataRegion;
            this.rowPointer = rowPointer;
            this.retVal = new MemoryRange<Memory>(frameDataRegion, 0L, 0L);
        }

        @Override
        @Nullable
        public MemoryRange<Memory> getObject() {
            this.retVal.set(this.frameDataRegion, this.rowPointer.position(), this.rowPointer.length());
            return this.retVal;
        }

        @Override
        public Class classOfObject() {
            return MemoryRange.class;
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }
    }
}

