/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.druid.guice.StandardURLClassLoader;

public class ExtensionFirstClassLoader
extends StandardURLClassLoader {
    private final ClassLoader druidLoader;

    public ExtensionFirstClassLoader(URL[] urls, ClassLoader druidLoader, List<ClassLoader> extensionDependencyClassLoaders) {
        super(urls, null, extensionDependencyClassLoaders);
        this.druidLoader = (ClassLoader)Preconditions.checkNotNull((Object)druidLoader, (Object)"druidLoader");
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                try {
                    clazz = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    try {
                        clazz = this.loadClassFromExtensionDependencies(name);
                    }
                    catch (ClassNotFoundException e2) {
                        clazz = this.druidLoader.loadClass(name);
                    }
                }
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    @Override
    public URL getResource(String name) {
        URL resourceFromExtension = super.getResource(name);
        if (resourceFromExtension != null) {
            return resourceFromExtension;
        }
        resourceFromExtension = this.getResourceFromExtensionsDependencies(name);
        if (resourceFromExtension != null) {
            return resourceFromExtension;
        }
        return this.druidLoader.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Iterators.addAll(urls, (Iterator)Iterators.forEnumeration(super.getResources(name)));
        this.addExtensionResources(name, urls);
        Iterators.addAll(urls, (Iterator)Iterators.forEnumeration(this.druidLoader.getResources(name)));
        return Iterators.asEnumeration(urls.iterator());
    }
}

