/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Function;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.IOE;

public class LimitedOutputStream
extends OutputStream {
    private final OutputStream out;
    private final long limit;
    private final Function<Long, String> exceptionMessageFn;
    long written;

    public LimitedOutputStream(OutputStream out, long limit, Function<Long, String> exceptionMessageFn) {
        this.out = out;
        this.limit = limit;
        this.exceptionMessageFn = exceptionMessageFn;
        if (limit < 0L) {
            throw DruidException.defensive("Limit[%s] must be greater than or equal to zero", limit);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.plus(1);
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.plus(b.length);
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.plus(len);
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    private void plus(int n) throws IOException {
        this.written += (long)n;
        if (this.written > this.limit) {
            throw new IOE(this.exceptionMessageFn.apply(this.limit), new Object[0]);
        }
    }
}

