/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.granularity;

import com.google.common.collect.FluentIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.druid.common.guava.SettableSupplier;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.joda.time.Interval;

public class IntervalsByGranularity {
    private final List<Interval> sortedNonOverlappingIntervals;
    private final Granularity granularity;

    public IntervalsByGranularity(Collection<Interval> intervals, Granularity granularity) {
        this.sortedNonOverlappingIntervals = JodaUtils.condenseIntervals(intervals);
        this.granularity = granularity;
    }

    public Iterator<Interval> granularityIntervalsIterator() {
        if (this.sortedNonOverlappingIntervals.isEmpty()) {
            return Collections.emptyIterator();
        }
        SettableSupplier previous = new SettableSupplier();
        return FluentIterable.from(this.sortedNonOverlappingIntervals).transformAndConcat(this.granularity::getIterable).filter(interval -> {
            if (previous.get() != null && ((Interval)previous.get()).equals(interval)) {
                return false;
            }
            previous.set(interval);
            return true;
        }).iterator();
    }
}

