/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;
import org.apache.druid.java.util.metrics.KeyedDiff;
import org.apache.druid.java.util.metrics.MonitorUtils;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.Disk;
import org.apache.druid.java.util.metrics.cgroups.ProcSelfCgroupDiscoverer;

public class CgroupDiskMonitor
extends FeedDefiningMonitor {
    final CgroupDiscoverer cgroupDiscoverer;
    final Map<String, String[]> dimensions;
    private final KeyedDiff diff = new KeyedDiff();

    public CgroupDiskMonitor(CgroupDiscoverer cgroupDiscoverer, Map<String, String[]> dimensions, String feed) {
        super(feed);
        this.cgroupDiscoverer = cgroupDiscoverer;
        this.dimensions = dimensions;
    }

    public CgroupDiskMonitor(Map<String, String[]> dimensions, String feed) {
        this(new ProcSelfCgroupDiscoverer(), dimensions, feed);
    }

    public CgroupDiskMonitor(Map<String, String[]> dimensions) {
        this(dimensions, "metrics");
    }

    public CgroupDiskMonitor() {
        this((Map<String, String[]>)ImmutableMap.of());
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        Map<String, Disk.Metrics> snapshot = new Disk(this.cgroupDiscoverer).snapshot();
        for (Map.Entry<String, Disk.Metrics> entry : snapshot.entrySet()) {
            Map<String, Long> stats = this.diff.to(entry.getKey(), (Map<String, Long>)ImmutableMap.builder().put((Object)"cgroup/disk/read/bytes", (Object)entry.getValue().getReadBytes()).put((Object)"cgroup/disk/read/count", (Object)entry.getValue().getReadCount()).put((Object)"cgroup/disk/write/bytes", (Object)entry.getValue().getWriteBytes()).put((Object)"cgroup/disk/write/count", (Object)entry.getValue().getWriteCount()).build());
            if (stats == null) continue;
            ServiceMetricEvent.Builder builder = this.builder().setDimension("diskName", entry.getValue().getDiskName());
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            for (Map.Entry<String, Long> stat : stats.entrySet()) {
                emitter.emit(builder.setMetric(stat.getKey(), stat.getValue()));
            }
        }
        return true;
    }
}

