/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.Order;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class CursorGranularizer {
    private final Cursor cursor;
    private final Iterable<Interval> bucketIterable;
    @Nullable
    private final ColumnValueSelector timeSelector;
    private final boolean descending;
    private long currentBucketStart;
    private long currentBucketEnd;

    @Nullable
    public static CursorGranularizer create(Cursor cursor, @Nullable TimeBoundaryInspector timeBoundaryInspector, Order timeOrder, Granularity granularity, Interval queryInterval) {
        ColumnValueSelector timeSelector;
        Interval firstBucket;
        if (!Granularities.ALL.equals(granularity) && timeOrder == Order.NONE) {
            throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.UNSUPPORTED).build("Cannot use granularity[%s] on non-time-sorted data.", granularity);
        }
        Interval clippedQueryInterval = timeBoundaryInspector != null ? queryInterval.overlap((ReadableInterval)new Interval((ReadableInstant)timeBoundaryInspector.getMinTime(), (ReadableInstant)granularity.bucketEnd(timeBoundaryInspector.getMaxTime()))) : queryInterval;
        if (clippedQueryInterval == null) {
            return null;
        }
        List bucketIterable = granularity.getIterable(clippedQueryInterval);
        if (timeOrder == Order.DESCENDING) {
            bucketIterable = Lists.reverse((List)ImmutableList.copyOf(bucketIterable));
        }
        if ((firstBucket = granularity.bucket(clippedQueryInterval.getStart())).contains((ReadableInterval)clippedQueryInterval)) {
            assert (Iterables.size((Iterable)bucketIterable) == 1);
            timeSelector = null;
        } else {
            timeSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("__time");
        }
        return new CursorGranularizer(cursor, bucketIterable, timeSelector, timeOrder == Order.DESCENDING);
    }

    private CursorGranularizer(Cursor cursor, Iterable<Interval> bucketIterable, @Nullable ColumnValueSelector timeSelector, boolean descending) {
        this.cursor = cursor;
        this.bucketIterable = bucketIterable;
        this.timeSelector = timeSelector;
        this.descending = descending;
    }

    public Iterable<Interval> getBucketIterable() {
        return this.bucketIterable;
    }

    public DateTime getBucketStart() {
        return DateTimes.utc(this.currentBucketStart);
    }

    public Interval getCurrentInterval() {
        return Intervals.utc(this.currentBucketStart, this.currentBucketEnd);
    }

    public boolean advanceToBucket(Interval bucketInterval) {
        this.currentBucketStart = bucketInterval.getStartMillis();
        this.currentBucketEnd = bucketInterval.getEndMillis();
        if (this.cursor.isDone()) {
            return false;
        }
        if (this.timeSelector == null) {
            return true;
        }
        long currentTime = this.timeSelector.getLong();
        if (this.descending) {
            while (currentTime >= this.currentBucketEnd && !this.cursor.isDone()) {
                this.cursor.advance();
                if (this.cursor.isDone()) continue;
                currentTime = this.timeSelector.getLong();
            }
        } else {
            while (currentTime < this.currentBucketStart && !this.cursor.isDone()) {
                this.cursor.advance();
                if (this.cursor.isDone()) continue;
                currentTime = this.timeSelector.getLong();
            }
        }
        return this.currentBucketStart <= currentTime && currentTime < this.currentBucketEnd;
    }

    public boolean advanceCursorWithinBucket() {
        if (this.cursor.isDone()) {
            return false;
        }
        this.cursor.advance();
        return this.currentOffsetWithinBucket();
    }

    public boolean advanceCursorWithinBucketUninterruptedly() {
        if (this.cursor.isDone()) {
            return false;
        }
        this.cursor.advanceUninterruptibly();
        return this.currentOffsetWithinBucket();
    }

    public boolean currentOffsetWithinBucket() {
        if (this.cursor.isDone()) {
            return false;
        }
        if (this.timeSelector == null) {
            return true;
        }
        long currentTime = this.timeSelector.getLong();
        return this.currentBucketStart <= currentTime && currentTime < this.currentBucketEnd;
    }
}

