/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.druid.query.aggregation.AggregatorUtil;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.LongSumAggregator;
import org.apache.druid.query.aggregation.NullableNumericAggregatorFactory;
import org.apache.druid.query.aggregation.ObjectColumnLongAggregatorWrapper;
import org.apache.druid.query.aggregation.ObjectColumnLongBufferAggregatorWrapper;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorValueSelector;

public abstract class SimpleLongAggregatorFactory
extends NullableNumericAggregatorFactory<ColumnValueSelector> {
    protected final String name;
    @Nullable
    protected final String fieldName;
    @Nullable
    protected final String expression;
    protected final ExprMacroTable macroTable;
    protected final Supplier<Expr> fieldExpression;

    public SimpleLongAggregatorFactory(ExprMacroTable macroTable, String name, @Nullable String fieldName, @Nullable String expression) {
        this.macroTable = macroTable;
        this.name = name;
        this.fieldName = fieldName;
        this.expression = expression;
        this.fieldExpression = Parser.lazyParse(expression, macroTable);
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkArgument((boolean)(fieldName == null ^ expression == null), (Object)"Must have a valid, non-null fieldName or expression");
    }

    @Override
    protected Aggregator factorize(ColumnSelectorFactory metricFactory, ColumnValueSelector selector) {
        if (AggregatorUtil.shouldUseObjectColumnAggregatorWrapper(this.fieldName, metricFactory)) {
            return new ObjectColumnLongAggregatorWrapper(selector, this::buildAggregator, this.nullValue());
        }
        return this.buildAggregator(selector);
    }

    @Override
    protected BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory, ColumnValueSelector selector) {
        if (AggregatorUtil.shouldUseObjectColumnAggregatorWrapper(this.fieldName, metricFactory)) {
            return new ObjectColumnLongBufferAggregatorWrapper(selector, this::buildBufferAggregator, this.nullValue());
        }
        return this.buildBufferAggregator(selector);
    }

    @Override
    protected ColumnValueSelector selector(ColumnSelectorFactory metricFactory) {
        return AggregatorUtil.makeColumnValueSelectorWithLongDefault(metricFactory, this.fieldName, (Expr)this.fieldExpression.get(), this.nullValue());
    }

    @Override
    protected VectorValueSelector vectorSelector(VectorColumnSelectorFactory columnSelectorFactory) {
        return AggregatorUtil.makeVectorValueSelector(columnSelectorFactory, this.fieldName, this.expression, this.fieldExpression);
    }

    @Override
    protected boolean useGetObject(ColumnSelectorFactory columnSelectorFactory) {
        return AggregatorUtil.shouldUseObjectColumnAggregatorWrapper(this.fieldName, columnSelectorFactory);
    }

    @Override
    public Object deserialize(Object object) {
        return object;
    }

    @Override
    public ColumnType getIntermediateType() {
        return ColumnType.LONG;
    }

    @Override
    public int getMaxIntermediateSize() {
        return 8;
    }

    @Override
    public Comparator getComparator() {
        return LongSumAggregator.COMPARATOR;
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object;
    }

    @Override
    public List<String> requiredFields() {
        return this.fieldName != null ? Collections.singletonList(this.fieldName) : ((Expr)this.fieldExpression.get()).analyzeInputs().getRequiredBindingsList();
    }

    @Override
    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && this.getClass() == other.getClass()) {
            return this.getCombiningFactory();
        }
        throw new AggregatorFactoryNotMergeableException(this, other);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.expression, this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleLongAggregatorFactory that = (SimpleLongAggregatorFactory)o;
        if (!Objects.equals(this.fieldName, that.fieldName)) {
            return false;
        }
        if (!Objects.equals(this.expression, that.expression)) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFieldName() {
        return this.fieldName;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getExpression() {
        return this.expression;
    }

    @Override
    public boolean canVectorize(ColumnInspector columnInspector) {
        return AggregatorUtil.canVectorize(columnInspector, this.fieldName, this.expression, this.fieldExpression);
    }

    protected abstract long nullValue();

    protected abstract Aggregator buildAggregator(BaseLongColumnValueSelector var1);

    protected abstract BufferAggregator buildBufferAggregator(BaseLongColumnValueSelector var1);
}

