/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import org.apache.druid.query.aggregation.any.NumericAnyVectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;

public class FloatAnyVectorAggregator
extends NumericAnyVectorAggregator {
    public FloatAnyVectorAggregator(VectorValueSelector vectorValueSelector) {
        super(vectorValueSelector);
    }

    @Override
    void initValue(ByteBuffer buf, int position) {
        buf.putFloat(position, 0.0f);
    }

    @Override
    boolean putAnyValueFromRow(ByteBuffer buf, int position, int startRow, int endRow) {
        boolean isRowsWithinIndex;
        float[] values = this.vectorValueSelector.getFloatVector();
        boolean bl = isRowsWithinIndex = startRow < endRow && startRow < values.length;
        if (isRowsWithinIndex) {
            buf.putFloat(position, values[startRow]);
        }
        return isRowsWithinIndex;
    }

    @Override
    Object getNonNullObject(ByteBuffer buf, int position) {
        return Float.valueOf(buf.getFloat(position));
    }
}

