/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.post;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;

public class FieldAccessPostAggregator
implements PostAggregator {
    @Nullable
    private final String name;
    private final String fieldName;
    @Nullable
    private final ColumnType type;

    @JsonCreator
    public FieldAccessPostAggregator(@JsonProperty(value="name") @Nullable String name, @JsonProperty(value="fieldName") String fieldName) {
        this(name, fieldName, null);
    }

    private FieldAccessPostAggregator(@Nullable String name, String fieldName, @Nullable ColumnType type) {
        Preconditions.checkNotNull((Object)fieldName);
        this.name = name;
        this.fieldName = fieldName;
        this.type = type;
    }

    @Override
    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Comparator getComparator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object compute(Map<String, Object> combinedAggregators) {
        return combinedAggregators.get(this.fieldName);
    }

    @Override
    @Nullable
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public ColumnType getType(ColumnInspector signature) {
        if (this.type != null) {
            return this.type;
        }
        ColumnCapabilities capabilities = signature.getColumnCapabilities(this.fieldName);
        if (capabilities != null) {
            return capabilities.toColumnType();
        }
        return null;
    }

    @Override
    public FieldAccessPostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        ColumnType type = aggregators != null && aggregators.containsKey(this.fieldName) ? aggregators.get(this.fieldName).getIntermediateType() : null;
        return new FieldAccessPostAggregator(this.name, this.fieldName, type);
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(5).appendString(this.fieldName).build();
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    public String toString() {
        return "FieldAccessPostAggregator{name='" + this.name + "', fieldName='" + this.fieldName + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldAccessPostAggregator that = (FieldAccessPostAggregator)o;
        if (!this.fieldName.equals(that.fieldName)) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.fieldName.hashCode();
        return result;
    }
}

