/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.DimExtractionFn;
import org.apache.druid.query.extraction.ExtractionFn;

public class RegexDimExtractionFn
extends DimExtractionFn {
    private static final byte CACHE_KEY_SEPARATOR = -1;
    private final String expr;
    private final int index;
    private final Pattern pattern;
    private final boolean replaceMissingValue;
    private final String replaceMissingValueWith;

    @JsonCreator
    public RegexDimExtractionFn(@JsonProperty(value="expr") String expr, @JsonProperty(value="index") Integer index, @JsonProperty(value="replaceMissingValue") Boolean replaceMissingValue, @JsonProperty(value="replaceMissingValueWith") String replaceMissingValueWith) {
        Preconditions.checkNotNull((Object)expr, (Object)"expr must not be null");
        this.expr = expr;
        this.index = index == null ? 1 : index;
        this.pattern = Pattern.compile(expr);
        this.replaceMissingValue = replaceMissingValue == null ? false : replaceMissingValue;
        this.replaceMissingValueWith = replaceMissingValueWith;
    }

    public RegexDimExtractionFn(String expr, Boolean replaceMissingValue, String replaceMissingValueWith) {
        this(expr, null, replaceMissingValue, replaceMissingValueWith);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] byArray;
        byte[] exprBytes = StringUtils.toUtf8(this.expr);
        byte[] indexBytes = Ints.toByteArray((int)this.index);
        if (this.replaceMissingValue) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 1;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        }
        byte[] replaceBytes = byArray;
        byte[] replaceStrBytes = this.replaceMissingValueWith == null ? new byte[]{} : StringUtils.toUtf8(this.replaceMissingValueWith);
        int totalLen = 1 + exprBytes.length + indexBytes.length + replaceBytes.length + replaceStrBytes.length;
        return ByteBuffer.allocate(totalLen += 2).put((byte)1).put(exprBytes).put((byte)-1).put(indexBytes).put(replaceStrBytes).put((byte)-1).put(replaceBytes).array();
    }

    @Override
    @Nullable
    public String apply(@Nullable String dimValue) {
        Matcher matcher;
        Matcher matcher2 = matcher = dimValue == null ? null : this.pattern.matcher(dimValue);
        String retVal = matcher != null && matcher.find() ? matcher.group(this.index) : (this.replaceMissingValue ? this.replaceMissingValueWith : dimValue);
        return retVal;
    }

    @JsonProperty(value="expr")
    public String getExpr() {
        return this.expr;
    }

    @JsonProperty
    public int getIndex() {
        return this.index;
    }

    @JsonProperty(value="replaceMissingValue")
    public boolean isReplaceMissingValue() {
        return this.replaceMissingValue;
    }

    @JsonProperty(value="replaceMissingValueWith")
    public String getReplaceMissingValueWith() {
        return this.replaceMissingValueWith;
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public String toString() {
        return StringUtils.format("regex(/%s/, %d)", this.expr, this.index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexDimExtractionFn that = (RegexDimExtractionFn)o;
        return this.index == that.index && this.replaceMissingValue == that.replaceMissingValue && Objects.equals(this.expr, that.expr) && Objects.equals(this.replaceMissingValueWith, that.replaceMissingValueWith);
    }

    public int hashCode() {
        return Objects.hash(this.expr, this.index, this.replaceMissingValue, this.replaceMissingValueWith);
    }
}

