/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.ExpressionPlan;

public enum DeferExpressionDimensions {
    SINGLE_STRING("singleString"){

        @Override
        public boolean useDeferredGroupBySelector(ExpressionPlan plan, List<String> requiredBindingsList, ColumnInspector inspector) {
            return false;
        }
    }
    ,
    FIXED_WIDTH("fixedWidth"){

        @Override
        public boolean useDeferredGroupBySelector(ExpressionPlan plan, List<String> requiredBindingsList, ColumnInspector inspector) {
            if (DeferExpressionDimensions.isInnatelyDeferrable(plan, requiredBindingsList, inspector)) {
                return false;
            }
            for (String requiredBinding : requiredBindingsList) {
                ColumnCapabilities capabilities = inspector.getColumnCapabilities(requiredBinding);
                if (capabilities == null) {
                    return false;
                }
                if (capabilities.isNumeric() || DeferExpressionDimensions.isDictionaryEncodedScalarString(capabilities)) continue;
                return false;
            }
            return true;
        }
    }
    ,
    FIXED_WIDTH_NON_NUMERIC("fixedWidthNonNumeric"){

        @Override
        public boolean useDeferredGroupBySelector(ExpressionPlan plan, List<String> requiredBindingsList, ColumnInspector inspector) {
            if (DeferExpressionDimensions.isInnatelyDeferrable(plan, requiredBindingsList, inspector)) {
                return false;
            }
            boolean allNumericInputs = true;
            for (String requiredBinding : requiredBindingsList) {
                ColumnCapabilities capabilities = inspector.getColumnCapabilities(requiredBinding);
                if (capabilities == null) {
                    return false;
                }
                boolean bl = allNumericInputs = allNumericInputs && capabilities.isNumeric();
                if (capabilities.isNumeric() || DeferExpressionDimensions.isDictionaryEncodedScalarString(capabilities)) continue;
                return false;
            }
            return !allNumericInputs || plan.getOutputType() != null && !plan.getOutputType().isNumeric();
        }
    }
    ,
    ALWAYS("always"){

        @Override
        public boolean useDeferredGroupBySelector(ExpressionPlan plan, List<String> requiredBindingsList, ColumnInspector inspector) {
            return !DeferExpressionDimensions.isInnatelyDeferrable(plan, requiredBindingsList, inspector);
        }
    };

    public static final String JSON_KEY = "deferExpressionDimensions";
    private final String jsonName;

    private DeferExpressionDimensions(String jsonName) {
        this.jsonName = jsonName;
    }

    @JsonCreator
    public static DeferExpressionDimensions fromString(String jsonName) {
        for (DeferExpressionDimensions value : DeferExpressionDimensions.values()) {
            if (!value.jsonName.equals(jsonName)) continue;
            return value;
        }
        throw new IAE("Invalid value[%s] for[%s]", jsonName, JSON_KEY);
    }

    public abstract boolean useDeferredGroupBySelector(ExpressionPlan var1, List<String> var2, ColumnInspector var3);

    @JsonValue
    public String toString() {
        return this.jsonName;
    }

    private static boolean isDictionaryEncodedScalarString(ColumnCapabilities capabilities) {
        return capabilities.isDictionaryEncoded().isTrue() && capabilities.is(ValueType.STRING) && capabilities.hasMultipleValues().isFalse();
    }

    private static boolean isInnatelyDeferrable(ExpressionPlan plan, List<String> requiredBindingsList, ColumnInspector inspector) {
        if (plan.getOutputType() != null && plan.getOutputType().is(ExprType.STRING) && requiredBindingsList.size() <= 1) {
            for (String requiredBinding : requiredBindingsList) {
                ColumnCapabilities requiredBindingCapabilities = inspector.getColumnCapabilities(requiredBinding);
                if (requiredBindingCapabilities != null && requiredBindingCapabilities.is(ValueType.STRING) && requiredBindingCapabilities.isDictionaryEncoded().isTrue()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

